/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.ddl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.query.Query;
import io.stargate.db.query.builder.QueryBuilder;
import io.stargate.graphql.schema.cqlfirst.ddl.fetchers.DdlQueryFetcher;

public class DropKeyspaceFetcher
extends DdlQueryFetcher {
    public DropKeyspaceFetcher(AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(authorizationService, dataStoreFactory);
    }

    @Override
    protected Query<?> buildQuery(DataFetchingEnvironment dataFetchingEnvironment, QueryBuilder builder, AuthenticationSubject authenticationSubject) throws UnauthorizedException {
        String keyspaceName = (String)dataFetchingEnvironment.getArgument("name");
        this.authorizationService.authorizeSchemaWrite(authenticationSubject, keyspaceName, null, Scope.DROP, SourceAPI.GRAPHQL);
        boolean ifExists = (Boolean)dataFetchingEnvironment.getArgumentOrDefault("ifExists", (Object)Boolean.FALSE);
        return builder.drop().keyspace(keyspaceName).ifExists(ifExists).build();
    }
}

