/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.Parameters;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.DataStoreOptions;
import io.stargate.db.datastore.ImmutableDataStoreOptions;
import io.stargate.graphql.web.HttpAwareContext;
import org.apache.cassandra.stargate.db.ConsistencyLevel;

public abstract class CassandraFetcher<ResultT>
implements DataFetcher<ResultT> {
    protected final AuthorizationService authorizationService;
    private final DataStoreFactory dataStoreFactory;
    public static final ConsistencyLevel DEFAULT_CONSISTENCY = ConsistencyLevel.LOCAL_QUORUM;
    public static final ConsistencyLevel DEFAULT_SERIAL_CONSISTENCY = ConsistencyLevel.SERIAL;
    public static final int DEFAULT_PAGE_SIZE = 100;
    public static final Parameters DEFAULT_PARAMETERS = Parameters.builder().pageSize(100).consistencyLevel(DEFAULT_CONSISTENCY).serialConsistencyLevel(DEFAULT_SERIAL_CONSISTENCY).build();

    public CassandraFetcher(AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        this.authorizationService = authorizationService;
        this.dataStoreFactory = dataStoreFactory;
    }

    public final ResultT get(DataFetchingEnvironment environment) throws Exception {
        HttpAwareContext httpAwareContext = (HttpAwareContext)environment.getContext();
        AuthenticationSubject authenticationSubject = httpAwareContext.getSubject();
        Parameters parameters = this.getDatastoreParameters(environment);
        ImmutableDataStoreOptions dataStoreOptions = DataStoreOptions.builder().putAllCustomProperties(httpAwareContext.getAllHeaders()).defaultParameters(parameters).alwaysPrepareQueries(true).build();
        DataStore dataStore = this.dataStoreFactory.create(authenticationSubject.asUser(), (DataStoreOptions)dataStoreOptions);
        return this.get(environment, dataStore, authenticationSubject);
    }

    protected Parameters getDatastoreParameters(DataFetchingEnvironment environment) {
        return DEFAULT_PARAMETERS;
    }

    protected abstract ResultT get(DataFetchingEnvironment var1, DataStore var2, AuthenticationSubject var3) throws Exception;
}

