/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.types.scalars;

import graphql.schema.CoercingParseLiteralException;
import io.stargate.graphql.schema.cqlfirst.dml.types.scalars.TemporalCoercing;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;

class TimestampCoercing
extends TemporalCoercing<Instant> {
    static TimestampCoercing INSTANCE = new TimestampCoercing();
    private static final String[] DATE_STRING_PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mmX", "yyyy-MM-dd'T'HH:mmXX", "yyyy-MM-dd'T'HH:mmXXX", "yyyy-MM-dd'T'HH:mm:ssX", "yyyy-MM-dd'T'HH:mm:ssXX", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss.SSSX", "yyyy-MM-dd'T'HH:mm:ss.SSSXX", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd'T'HH:mm z", "yyyy-MM-dd'T'HH:mm:ss z", "yyyy-MM-dd'T'HH:mm:ss.SSS z", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mmX", "yyyy-MM-dd HH:mmXX", "yyyy-MM-dd HH:mmXXX", "yyyy-MM-dd HH:mm:ssX", "yyyy-MM-dd HH:mm:ssXX", "yyyy-MM-dd HH:mm:ssXXX", "yyyy-MM-dd HH:mm:ss.SSSX", "yyyy-MM-dd HH:mm:ss.SSSXX", "yyyy-MM-dd HH:mm:ss.SSSXXX", "yyyy-MM-dd HH:mm z", "yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd HH:mm:ss.SSS z", "yyyy-MM-dd", "yyyy-MM-ddX", "yyyy-MM-ddXX", "yyyy-MM-ddXXX", "yyyy-MM-dd z"};
    private final ThreadLocal<SimpleDateFormat> parser = ThreadLocal.withInitial(() -> {
        SimpleDateFormat parser = new SimpleDateFormat();
        parser.setLenient(false);
        parser.setTimeZone(TimeZone.getTimeZone(zoneId));
        return parser;
    });
    private final ThreadLocal<SimpleDateFormat> formatter = ThreadLocal.withInitial(() -> {
        SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        parser.setTimeZone(TimeZone.getTimeZone(zoneId));
        return parser;
    });

    private TimestampCoercing() {
        this(ZoneId.systemDefault());
    }

    private TimestampCoercing(ZoneId zoneId) {
    }

    @Override
    protected String format(Instant value) {
        return this.formatter.get().format(java.sql.Date.from(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Instant parse(String value) {
        SimpleDateFormat parser = this.parser.get();
        TimeZone timeZone = parser.getTimeZone();
        ParsePosition pos = new ParsePosition(0);
        for (String pattern : DATE_STRING_PATTERNS) {
            parser.applyPattern(pattern);
            pos.setIndex(0);
            try {
                Date date = parser.parse(value, pos);
                if (date == null || pos.getIndex() != value.length()) continue;
                Instant instant = date.toInstant();
                return instant;
            }
            finally {
                parser.setTimeZone(timeZone);
            }
        }
        throw new CoercingParseLiteralException("Cannot parse Timestamp value");
    }

    @Override
    protected Instant parse(long value) {
        return Instant.ofEpochMilli(value);
    }
}

