/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.types.scalars;

import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigInteger;

class BigIntCoercing
implements Coercing<Long, String> {
    static final BigIntCoercing INSTANCE = new BigIntCoercing();

    private BigIntCoercing() {
    }

    public String serialize(Object dataFetcherResult) throws CoercingSerializeException {
        assert (dataFetcherResult instanceof Long);
        return dataFetcherResult.toString();
    }

    public Long parseValue(Object input) throws CoercingParseValueException {
        if (input instanceof BigInteger) {
            return this.fromBigInteger((BigInteger)input);
        }
        if (input instanceof Integer || input instanceof Long) {
            return ((Number)input).longValue();
        }
        if (input instanceof String) {
            return this.parse((String)input);
        }
        throw new CoercingParseLiteralException("Expected a string or integer literal");
    }

    public Long parseLiteral(Object input) throws CoercingParseLiteralException {
        if (input instanceof StringValue) {
            return this.parse(((StringValue)input).getValue());
        }
        if (input instanceof IntValue) {
            return this.fromBigInteger(((IntValue)input).getValue());
        }
        throw new CoercingParseLiteralException("Expected a string or integer literal");
    }

    private Long fromBigInteger(BigInteger input) {
        try {
            return input.longValueExact();
        }
        catch (ArithmeticException e) {
            throw new CoercingParseLiteralException("Out of bounds");
        }
    }

    private long parse(String input) {
        try {
            return Long.parseLong(input);
        }
        catch (NumberFormatException e) {
            throw new CoercingParseLiteralException("Invalid format");
        }
    }
}

