/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.fetchers;

import com.google.common.collect.ImmutableList;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.ImmutableParameters;
import io.stargate.db.Parameters;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.CassandraFetcher;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.DataTypeMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.FilterOperator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stargate.db.ConsistencyLevel;

public abstract class DmlFetcher<ResultT>
extends CassandraFetcher<ResultT> {
    protected final Table table;
    protected final NameMapping nameMapping;

    protected DmlFetcher(Table table, NameMapping nameMapping, AuthenticationService authenticationService, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(authenticationService, authorizationService, dataStoreFactory);
        this.table = table;
        this.nameMapping = nameMapping;
    }

    @Override
    protected Parameters getDatastoreParameters(DataFetchingEnvironment environment) {
        Object pageState;
        Object pageSize;
        Object serialConsistency;
        Map options = (Map)environment.getArgument("options");
        if (options == null) {
            return DEFAULT_PARAMETERS;
        }
        ImmutableParameters.Builder builder = Parameters.builder().from(DEFAULT_PARAMETERS);
        Object consistency = options.get("consistency");
        if (consistency != null) {
            builder.consistencyLevel(ConsistencyLevel.valueOf((String)((String)consistency)));
        }
        if ((serialConsistency = options.get("serialConsistency")) != null) {
            builder.serialConsistencyLevel(ConsistencyLevel.valueOf((String)((String)serialConsistency)));
        }
        if ((pageSize = options.get("pageSize")) != null) {
            builder.pageSize(((Integer)pageSize).intValue());
        }
        if ((pageState = options.get("pageState")) != null) {
            builder.pagingState(ByteBuffer.wrap(Base64.getDecoder().decode((String)pageState)));
        }
        return builder.build();
    }

    protected List<BuiltCondition> buildConditions(Table table, Map<String, Map<String, Object>> columnList) {
        if (columnList == null) {
            return ImmutableList.of();
        }
        ArrayList<BuiltCondition> where = new ArrayList<BuiltCondition>();
        for (Map.Entry<String, Map<String, Object>> clauseEntry : columnList.entrySet()) {
            Column column = this.getColumn(table, clauseEntry.getKey());
            for (Map.Entry<String, Object> condition : clauseEntry.getValue().entrySet()) {
                FilterOperator operator = FilterOperator.fromFieldName(condition.getKey());
                where.add(operator.buildCondition(column, condition.getValue(), this.nameMapping));
            }
        }
        return where;
    }

    protected List<BuiltCondition> buildClause(Table table, DataFetchingEnvironment environment) {
        if (environment.containsArgument("filter")) {
            Map columnList = (Map)environment.getArgument("filter");
            return this.buildConditions(table, columnList);
        }
        Map value = (Map)environment.getArgument("value");
        ArrayList<BuiltCondition> relations = new ArrayList<BuiltCondition>();
        if (value == null) {
            return ImmutableList.of();
        }
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.getColumn(table, (String)entry.getKey());
            Object whereValue = this.toDBValue(column.type(), entry.getValue());
            relations.add(BuiltCondition.of((String)column.name(), (Predicate)Predicate.EQ, (Object)whereValue));
        }
        return relations;
    }

    protected String getDBColumnName(Table table, String fieldName) {
        Column column = this.getColumn(table, fieldName);
        if (column == null) {
            return null;
        }
        return column.name();
    }

    protected Column getColumn(Table table, String fieldName) {
        String columnName = this.nameMapping.getCqlName(table, fieldName);
        return table.column(columnName);
    }

    protected Object toDBValue(Column column, Object value) {
        return this.toDBValue(column.type(), value);
    }

    private Object toDBValue(Column.ColumnType type, Object value) {
        return DataTypeMapping.toDBValue(type, value, this.nameMapping);
    }
}

