/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.ddl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.query.Query;
import io.stargate.db.query.builder.QueryBuilder;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableUserDefinedType;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.cqlfirst.ddl.fetchers.DdlQueryFetcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CreateTypeFetcher
extends DdlQueryFetcher {
    public CreateTypeFetcher(AuthenticationService authenticationService, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(authenticationService, authorizationService, dataStoreFactory);
    }

    @Override
    protected Query<?> buildQuery(DataFetchingEnvironment dataFetchingEnvironment, QueryBuilder builder, AuthenticationSubject authenticationSubject) throws UnauthorizedException {
        String keyspaceName = (String)dataFetchingEnvironment.getArgument("keyspaceName");
        String typeName = (String)dataFetchingEnvironment.getArgument("typeName");
        this.authorizationService.authorizeSchemaWrite(authenticationSubject, keyspaceName, null, Scope.CREATE, SourceAPI.GRAPHQL);
        List fieldList = (List)dataFetchingEnvironment.getArgument("fields");
        if (fieldList.isEmpty()) {
            throw new IllegalArgumentException("Must have at least one field");
        }
        ArrayList<Column> fields = new ArrayList<Column>(fieldList.size());
        for (Map key : fieldList) {
            fields.add(Column.create((String)((String)key.get("name")), (Column.ColumnType)this.decodeType(key.get("type"))));
        }
        ImmutableUserDefinedType udt = ImmutableUserDefinedType.builder().keyspace(keyspaceName).name(typeName).addAllColumns(fields).build();
        Boolean ifNotExists = (Boolean)dataFetchingEnvironment.getArgument("ifNotExists");
        return builder.create().type(keyspaceName, (UserDefinedType)udt).ifNotExists(ifNotExists != null && ifNotExists != false).build();
    }
}

