/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.ddl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.query.Query;
import io.stargate.db.query.builder.QueryBuilder;
import io.stargate.db.schema.CollectionIndexingType;
import io.stargate.db.schema.ImmutableCollectionIndexingType;
import io.stargate.graphql.schema.cqlfirst.ddl.fetchers.IndexFetcher;

public class CreateIndexFetcher
extends IndexFetcher {
    public CreateIndexFetcher(AuthenticationService authenticationService, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(authenticationService, authorizationService, dataStoreFactory, Scope.CREATE);
    }

    @Override
    protected Query<?> buildQuery(DataFetchingEnvironment dataFetchingEnvironment, QueryBuilder builder, String keyspaceName, String tableName) {
        String columnName = (String)dataFetchingEnvironment.getArgument("columnName");
        String indexName = (String)dataFetchingEnvironment.getArgument("indexName");
        boolean ifNotExists = (Boolean)dataFetchingEnvironment.getArgumentOrDefault("ifNotExists", (Object)Boolean.FALSE);
        String customIndexClass = (String)dataFetchingEnvironment.getArgumentOrDefault("indexType", null);
        String indexKind = (String)dataFetchingEnvironment.getArgumentOrDefault("indexKind", null);
        boolean indexKeys = false;
        boolean indexEntries = false;
        boolean indexValues = false;
        boolean indexFull = false;
        if (indexKind != null) {
            switch (indexKind) {
                case "KEYS": {
                    indexKeys = true;
                    break;
                }
                case "VALUES": {
                    indexValues = true;
                    break;
                }
                case "ENTRIES": {
                    indexEntries = true;
                    break;
                }
                case "FULL": {
                    indexFull = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Invalid indexKind value: %s", indexKind));
                }
            }
        }
        ImmutableCollectionIndexingType indexingType = ImmutableCollectionIndexingType.builder().indexEntries(indexEntries).indexKeys(indexKeys).indexValues(indexValues).indexFull(indexFull).build();
        return builder.create().custom(customIndexClass).index(indexName).ifNotExists(ifNotExists).on(keyspaceName, tableName).column(columnName).indexingType((CollectionIndexingType)indexingType).build();
    }
}

