/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.ddl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.CassandraFetcher;
import io.stargate.graphql.schema.cqlfirst.ddl.fetchers.KeyspaceDto;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllKeyspacesFetcher
extends CassandraFetcher<List<KeyspaceDto>> {
    private static final Logger LOG = LoggerFactory.getLogger(AllKeyspacesFetcher.class);

    public AllKeyspacesFetcher(AuthenticationService authenticationService, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(authenticationService, authorizationService, dataStoreFactory);
    }

    @Override
    protected List<KeyspaceDto> get(DataFetchingEnvironment environment, DataStore dataStore, AuthenticationSubject authenticationSubject) {
        return dataStore.schema().keyspaces().stream().filter(keyspace -> {
            try {
                this.authorizationService.authorizeSchemaRead(authenticationSubject, Collections.singletonList(keyspace.name()), null, SourceAPI.GRAPHQL);
                return true;
            }
            catch (UnauthorizedException e) {
                LOG.debug("Not returning keyspace {} due to not being authorized", (Object)keyspace.name());
                return false;
            }
        }).map(keyspace -> new KeyspaceDto((Keyspace)keyspace, this.authorizationService, authenticationSubject)).collect(Collectors.toList());
    }
}

