/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources.cqlfirst;

import graphql.GraphQL;
import io.stargate.graphql.web.RequestToHeadersMapper;
import io.stargate.graphql.web.models.GraphqlJsonBody;
import io.stargate.graphql.web.resources.GraphqlResourceBase;
import io.stargate.graphql.web.resources.cqlfirst.GraphqlCache;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/graphql")
@Singleton
public class GraphqlDmlResource
extends GraphqlResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(GraphqlDmlResource.class);
    private static final Pattern KEYSPACE_NAME_PATTERN = Pattern.compile("\\w+");
    @Inject
    private GraphqlCache graphqlCache;

    @GET
    public void get(@QueryParam(value="query") String query, @QueryParam(value="operationName") String operationName, @QueryParam(value="variables") String variables, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        GraphQL graphql = this.getDefaultGraphql(asyncResponse);
        if (graphql != null) {
            GraphqlDmlResource.get(query, operationName, variables, graphql, httpRequest, asyncResponse);
        }
    }

    @GET
    @Path(value="/{keyspaceName}")
    public void get(@PathParam(value="keyspaceName") String keyspaceName, @QueryParam(value="query") String query, @QueryParam(value="operationName") String operationName, @QueryParam(value="variables") String variables, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        GraphQL graphql = this.getGraphl(keyspaceName, asyncResponse, httpRequest);
        if (graphql != null) {
            GraphqlDmlResource.get(query, operationName, variables, graphql, httpRequest, asyncResponse);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    public void postJson(GraphqlJsonBody jsonBody, @QueryParam(value="query") String queryFromUrl, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        GraphQL graphql = this.getDefaultGraphql(asyncResponse);
        if (graphql != null) {
            GraphqlDmlResource.postJson(jsonBody, queryFromUrl, graphql, httpRequest, asyncResponse);
        }
    }

    @POST
    @Path(value="/{keyspaceName}")
    @Consumes(value={"application/json"})
    public void postJson(@PathParam(value="keyspaceName") String keyspaceName, GraphqlJsonBody jsonBody, @QueryParam(value="query") String queryFromUrl, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        GraphQL graphql = this.getGraphl(keyspaceName, asyncResponse, httpRequest);
        if (graphql != null) {
            GraphqlDmlResource.postJson(jsonBody, queryFromUrl, graphql, httpRequest, asyncResponse);
        }
    }

    @POST
    @Consumes(value={"application/graphql"})
    public void postGraphql(String query, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        GraphQL graphql = this.getDefaultGraphql(asyncResponse);
        if (graphql != null) {
            GraphqlDmlResource.postGraphql(query, graphql, httpRequest, asyncResponse);
        }
    }

    @POST
    @Path(value="/{keyspaceName}")
    @Consumes(value={"application/graphql"})
    public void postGraphql(@PathParam(value="keyspaceName") String keyspaceName, String query, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        GraphQL graphql = this.getGraphl(keyspaceName, asyncResponse, httpRequest);
        if (graphql != null) {
            GraphqlDmlResource.postGraphql(query, graphql, httpRequest, asyncResponse);
        }
    }

    private GraphQL getDefaultGraphql(AsyncResponse asyncResponse) {
        GraphQL graphql = this.graphqlCache.getDefaultDml();
        if (graphql == null) {
            GraphqlDmlResource.replyWithGraphqlError(Response.Status.NOT_FOUND, "No default keyspace defined", asyncResponse);
            return null;
        }
        return graphql;
    }

    private GraphQL getGraphl(String keyspaceName, AsyncResponse asyncResponse, HttpServletRequest request) {
        if (!KEYSPACE_NAME_PATTERN.matcher(keyspaceName).matches()) {
            LOG.warn("Invalid keyspace in URI, this could be an XSS attack: {}", (Object)keyspaceName);
            GraphqlDmlResource.replyWithGraphqlError(Response.Status.BAD_REQUEST, "Invalid keyspace name", asyncResponse);
            return null;
        }
        GraphQL graphql = this.graphqlCache.getDml(keyspaceName, RequestToHeadersMapper.getAllHeaders(request));
        if (graphql == null) {
            GraphqlDmlResource.replyWithGraphqlError(Response.Status.NOT_FOUND, String.format("Unknown keyspace '%s'", keyspaceName), asyncResponse);
            return null;
        }
        return graphql;
    }
}

