/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.types.scalars;

import graphql.schema.CoercingParseLiteralException;
import io.stargate.graphql.schema.cqlfirst.dml.types.scalars.TemporalCoercing;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

class DateCoercing
extends TemporalCoercing<LocalDate> {
    static DateCoercing INSTANCE = new DateCoercing();
    private static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);
    private static final long MAX_CQL_LONG_VALUE = 0xFFFFFFFFL;
    private static final long EPOCH_AS_CQL_LONG = 0x80000000L;

    private DateCoercing() {
    }

    @Override
    protected String format(LocalDate value) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(value);
    }

    @Override
    protected LocalDate parse(String value) {
        try {
            return LocalDate.parse(value, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (RuntimeException e) {
            throw new CoercingParseLiteralException("Couldn't parse literal, expected ISO-8601 extended local date format (YYYY-MM-DD)");
        }
    }

    @Override
    protected LocalDate parse(long value) {
        int days = DateCoercing.cqlDateToDaysSinceEpoch(value);
        return EPOCH.plusDays(days);
    }

    private static int cqlDateToDaysSinceEpoch(long raw) {
        if (raw < 0L || raw > 0xFFFFFFFFL) {
            throw new CoercingParseLiteralException(String.format("Numeric Date literals must be between 0 and %d (got %d)", 0xFFFFFFFFL, raw));
        }
        return (int)(raw - 0x80000000L);
    }
}

