/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.ddl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.SourceAPI;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.CassandraFetcher;
import io.stargate.graphql.schema.cqlfirst.ddl.fetchers.KeyspaceDto;
import java.util.Collections;

public class SingleKeyspaceFetcher
extends CassandraFetcher<KeyspaceDto> {
    public SingleKeyspaceFetcher(AuthenticationService authenticationService, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(authenticationService, authorizationService, dataStoreFactory);
    }

    @Override
    protected KeyspaceDto get(DataFetchingEnvironment environment, DataStore dataStore, AuthenticationSubject authenticationSubject) throws Exception {
        String keyspaceName = (String)environment.getArgument("name");
        Keyspace keyspace = dataStore.schema().keyspace(keyspaceName);
        if (keyspace == null) {
            return null;
        }
        this.authorizationService.authorizeSchemaRead(authenticationSubject, Collections.singletonList(keyspace.name()), null, SourceAPI.GRAPHQL);
        return new KeyspaceDto(keyspace, this.authorizationService, authenticationSubject);
    }
}

