/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.ddl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.query.Query;
import io.stargate.db.query.builder.QueryBuilder;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.CassandraFetcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class DdlQueryFetcher
extends CassandraFetcher<Boolean> {
    protected DdlQueryFetcher(AuthenticationService authenticationService, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(authenticationService, authorizationService, dataStoreFactory);
    }

    @Override
    protected Boolean get(DataFetchingEnvironment environment, DataStore dataStore, AuthenticationSubject authenticationSubject) throws Exception {
        dataStore.execute(this.buildQuery(environment, dataStore.queryBuilder(), authenticationSubject).bind(new Object[0])).get();
        return true;
    }

    protected abstract Query<?> buildQuery(DataFetchingEnvironment var1, QueryBuilder var2, AuthenticationSubject var3) throws UnauthorizedException;

    protected Column.ColumnType decodeType(Object typeObject) {
        Map type = (Map)typeObject;
        String basic = (String)type.get("basic");
        Map info = (Map)type.get("info");
        String name = info == null ? null : (String)info.get("name");
        List subTypes = info == null ? null : (List)info.get("subTypes");
        boolean frozen = info != null && info.containsKey("frozen") && (Boolean)info.get("frozen") != false;
        switch (basic) {
            case "INT": {
                return Column.Type.Int;
            }
            case "INET": {
                return Column.Type.Inet;
            }
            case "TIMEUUID": {
                return Column.Type.Timeuuid;
            }
            case "TIMESTAMP": {
                return Column.Type.Timestamp;
            }
            case "BIGINT": {
                return Column.Type.Bigint;
            }
            case "TIME": {
                return Column.Type.Time;
            }
            case "DURATION": {
                return Column.Type.Duration;
            }
            case "VARINT": {
                return Column.Type.Varint;
            }
            case "UUID": {
                return Column.Type.Uuid;
            }
            case "BOOLEAN": {
                return Column.Type.Boolean;
            }
            case "TINYINT": {
                return Column.Type.Tinyint;
            }
            case "SMALLINT": {
                return Column.Type.Smallint;
            }
            case "ASCII": {
                return Column.Type.Ascii;
            }
            case "DECIMAL": {
                return Column.Type.Decimal;
            }
            case "BLOB": {
                return Column.Type.Blob;
            }
            case "VARCHAR": 
            case "TEXT": {
                return Column.Type.Text;
            }
            case "DOUBLE": {
                return Column.Type.Double;
            }
            case "COUNTER": {
                return Column.Type.Counter;
            }
            case "DATE": {
                return Column.Type.Date;
            }
            case "FLOAT": {
                return Column.Type.Float;
            }
            case "LIST": {
                if (info == null) {
                    throw new IllegalArgumentException("List type should contain an 'info' field specifying the sub type");
                }
                if (subTypes == null || subTypes.size() != 1) {
                    throw new IllegalArgumentException("List sub types should contain 1 item");
                }
                return Column.Type.List.of(new Column.ColumnType[]{this.decodeType(subTypes.get(0))}).frozen(frozen);
            }
            case "SET": {
                if (info == null) {
                    throw new IllegalArgumentException("Set type should contain an 'info' field specifying the sub type");
                }
                if (subTypes == null || subTypes.size() != 1) {
                    throw new IllegalArgumentException("Set sub types should contain 1 item");
                }
                subTypes = (List)info.get("subTypes");
                return Column.Type.Set.of(new Column.ColumnType[]{this.decodeType(subTypes.get(0))}).frozen(frozen);
            }
            case "MAP": {
                if (info == null) {
                    throw new IllegalArgumentException("Map type should contain an 'info' field specifying the sub types");
                }
                if (subTypes == null || subTypes.size() != 2) {
                    throw new IllegalArgumentException("Map sub types should contain 2 items");
                }
                return Column.Type.Map.of(new Column.ColumnType[]{this.decodeType(subTypes.get(0)), this.decodeType(subTypes.get(1))}).frozen(frozen);
            }
            case "UDT": {
                if (name == null) {
                    throw new IllegalArgumentException("UDT type should contain an 'info' field specifying the UDT name");
                }
                return UserDefinedType.reference((String)name).frozen(frozen);
            }
            case "TUPLE": {
                if (info == null) {
                    throw new IllegalArgumentException("TUPLE type should contain an 'info' field specifying the sub types");
                }
                if (subTypes.isEmpty()) {
                    throw new IllegalArgumentException("TUPLE type should have at least one sub type");
                }
                Column.ColumnType[] decodedSubTypes = new Column.ColumnType[subTypes.size()];
                for (int i = 0; i < subTypes.size(); ++i) {
                    decodedSubTypes[i] = this.decodeType(subTypes.get(i));
                }
                return Column.Type.Tuple.of(decodedSubTypes);
            }
        }
        throw new RuntimeException(String.format("Data type %s is not supported", basic));
    }

    protected Column decodeColumn(Map<String, Object> key, Column.Kind kind) {
        return Column.create((String)((String)key.get("name")), (Column.Kind)kind, (Column.ColumnType)this.decodeType(key.get("type")), kind == Column.Kind.Clustering ? this.decodeClusteringOrder((String)key.get("order")) : null);
    }

    private Column.Order decodeClusteringOrder(String order) {
        if (order == null) {
            return Column.Order.ASC;
        }
        return Column.Order.valueOf((String)order.toUpperCase());
    }

    protected List<Column> decodeColumns(List<Map<String, Object>> columnList, Column.Kind kind) {
        if (columnList == null) {
            return Collections.emptyList();
        }
        ArrayList<Column> columns = new ArrayList<Column>(columnList.size());
        for (Map<String, Object> entry : columnList) {
            columns.add(this.decodeColumn(entry, kind));
        }
        return columns;
    }
}

