/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.TypedKeyValue;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.query.BoundDMLQuery;
import io.stargate.db.query.BoundDelete;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.MutationFetcher;
import io.stargate.graphql.web.HttpAwareContext;
import java.util.Map;

public class DeleteMutationFetcher
extends MutationFetcher {
    public DeleteMutationFetcher(Table table, NameMapping nameMapping, Persistence persistence, AuthenticationService authenticationService, AuthorizationService authorizationService) {
        super(table, nameMapping, persistence, authenticationService, authorizationService);
    }

    @Override
    protected BoundQuery buildQuery(DataFetchingEnvironment environment, DataStore dataStore) throws UnauthorizedException {
        HttpAwareContext httpAwareContext = (HttpAwareContext)environment.getContext();
        String token = httpAwareContext.getAuthToken();
        boolean ifExists = environment.containsArgument("ifExists") && environment.getArgument("ifExists") != null && (Boolean)environment.getArgument("ifExists") != false;
        BoundQuery bound = dataStore.queryBuilder().delete().from(this.table.keyspace(), this.table.name()).where(this.buildClause(this.table, environment)).ifs(this.buildConditions(this.table, (Map)environment.getArgument("ifCondition"))).ifExists(ifExists).build().bind(new Object[0]);
        assert (bound instanceof BoundDelete);
        this.authorizationService.authorizeDataWrite(token, this.table.keyspace(), this.table.name(), TypedKeyValue.forDML((BoundDMLQuery)((BoundDelete)bound)), Scope.DELETE, SourceAPI.GRAPHQL);
        return bound;
    }
}

