/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.ddl;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.Persistence;
import io.stargate.db.query.Query;
import io.stargate.db.query.builder.QueryBuilder;
import io.stargate.db.schema.Column;
import io.stargate.graphql.schema.fetchers.ddl.TableFetcher;
import java.util.List;

public class CreateTableFetcher
extends TableFetcher {
    public CreateTableFetcher(Persistence persistence, AuthenticationService authenticationService, AuthorizationService authorizationService) {
        super(persistence, authenticationService, authorizationService);
    }

    @Override
    protected Query<?> buildQuery(DataFetchingEnvironment dataFetchingEnvironment, QueryBuilder builder, String keyspaceName, String tableName) {
        Boolean ifNotExists = (Boolean)dataFetchingEnvironment.getArgument("ifNotExists");
        List partitionKeys = (List)dataFetchingEnvironment.getArgument("partitionKeys");
        if (partitionKeys.isEmpty()) {
            throw new IllegalArgumentException("partitionKeys must contain at least one element");
        }
        List clusteringKeys = (List)dataFetchingEnvironment.getArgument("clusteringKeys");
        List values = (List)dataFetchingEnvironment.getArgument("values");
        List<Column> partitionKeyColumns = this.decodeColumns(partitionKeys, Column.Kind.PartitionKey);
        List<Column> clusteringColumns = this.decodeColumns(clusteringKeys, Column.Kind.Clustering);
        List<Column> regularColumns = this.decodeColumns(values, Column.Kind.Regular);
        return builder.create().table(keyspaceName, tableName).ifNotExists(ifNotExists != null && ifNotExists != false).column(partitionKeyColumns).column(clusteringColumns).column(regularColumns).build();
    }
}

