/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.TypedKeyValue;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.query.BoundDMLQuery;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.query.builder.ValueModifier;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.MutationFetcher;
import io.stargate.graphql.web.HttpAwareContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateMutationFetcher
extends MutationFetcher {
    public UpdateMutationFetcher(Table table, NameMapping nameMapping, Persistence persistence, AuthenticationService authenticationService, AuthorizationService authorizationService) {
        super(table, nameMapping, persistence, authenticationService, authorizationService);
    }

    @Override
    protected BoundQuery buildQuery(DataFetchingEnvironment environment, DataStore dataStore) throws UnauthorizedException {
        boolean ifExists = environment.containsArgument("ifExists") && environment.getArgument("ifExists") != null && (Boolean)environment.getArgument("ifExists") != false;
        BoundQuery query = dataStore.queryBuilder().update(this.table.keyspace(), this.table.name()).ttl(this.getTTL(environment)).value(this.buildAssignments(this.table, environment)).where(this.buildPkCKWhere(this.table, environment)).ifs(this.buildConditions(this.table, (Map)environment.getArgument("ifCondition"))).ifExists(ifExists).build().bind(new Object[0]);
        HttpAwareContext httpAwareContext = (HttpAwareContext)environment.getContext();
        String token = httpAwareContext.getAuthToken();
        this.authorizationService.authorizeDataWrite(token, this.table.keyspace(), this.table.name(), TypedKeyValue.forDML((BoundDMLQuery)((BoundDMLQuery)query)), Scope.MODIFY);
        return query;
    }

    private List<BuiltCondition> buildPkCKWhere(Table table, DataFetchingEnvironment environment) {
        Map value = (Map)environment.getArgument("value");
        ArrayList<BuiltCondition> relations = new ArrayList<BuiltCondition>();
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.getColumn(table, (String)entry.getKey());
            if (!table.partitionKeyColumns().contains(column) && !table.clusteringKeyColumns().contains(column)) continue;
            relations.add(BuiltCondition.of((String)column.name(), (Predicate)Predicate.EQ, (Object)this.toDBValue(column, entry.getValue())));
        }
        return relations;
    }

    private List<ValueModifier> buildAssignments(Table table, DataFetchingEnvironment environment) {
        Map value = (Map)environment.getArgument("value");
        ArrayList<ValueModifier> assignments = new ArrayList<ValueModifier>();
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.getColumn(table, (String)entry.getKey());
            if (table.partitionKeyColumns().contains(column) || table.clusteringKeyColumns().contains(column)) continue;
            assignments.add(ValueModifier.set((String)column.name(), (Object)this.toDBValue(column, entry.getValue())));
        }
        return assignments;
    }
}

