/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.google.common.base.Preconditions;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.TypedKeyValue;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.query.BoundDMLQuery;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.builder.ValueModifier;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.MutationFetcher;
import io.stargate.graphql.web.HttpAwareContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InsertMutationFetcher
extends MutationFetcher {
    public InsertMutationFetcher(Table table, NameMapping nameMapping, Persistence persistence, AuthenticationService authenticationService, AuthorizationService authorizationService) {
        super(table, nameMapping, persistence, authenticationService, authorizationService);
    }

    @Override
    protected BoundQuery buildQuery(DataFetchingEnvironment environment, DataStore dataStore) throws UnauthorizedException {
        boolean ifNotExists = environment.containsArgument("ifNotExists") && environment.getArgument("ifNotExists") != null && (Boolean)environment.getArgument("ifNotExists") != false;
        BoundQuery query = dataStore.queryBuilder().insertInto(this.table.keyspace(), this.table.name()).value(this.buildInsertValues(environment)).ifNotExists(ifNotExists).ttl(this.getTTL(environment)).build().bind(new Object[0]);
        HttpAwareContext httpAwareContext = (HttpAwareContext)environment.getContext();
        String token = httpAwareContext.getAuthToken();
        this.authorizationService.authorizeDataWrite(token, this.table.keyspace(), this.table.name(), TypedKeyValue.forDML((BoundDMLQuery)((BoundDMLQuery)query)), Scope.MODIFY);
        return query;
    }

    private List<ValueModifier> buildInsertValues(DataFetchingEnvironment environment) {
        Map value = (Map)environment.getArgument("value");
        Preconditions.checkNotNull((Object)value, (Object)"Insert statement must contain at least one field");
        ArrayList<ValueModifier> modifiers = new ArrayList<ValueModifier>();
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.getColumn(this.table, (String)entry.getKey());
            modifiers.add(ValueModifier.set((String)column.name(), (Object)this.toDBValue(column, entry.getValue())));
        }
        return modifiers;
    }
}

