/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.ddl;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.fetchers.CassandraFetcher;
import io.stargate.graphql.schema.fetchers.ddl.KeyspaceFormatter;
import io.stargate.graphql.web.HttpAwareContext;
import java.util.Map;

public class SingleKeyspaceFetcher
extends CassandraFetcher<Map<String, Object>> {
    public SingleKeyspaceFetcher(Persistence persistence, AuthenticationService authenticationService, AuthorizationService authorizationService) {
        super(persistence, authenticationService, authorizationService);
    }

    @Override
    protected Map<String, Object> get(DataFetchingEnvironment environment, DataStore dataStore) {
        String keyspaceName = (String)environment.getArgument("name");
        HttpAwareContext httpAwareContext = (HttpAwareContext)environment.getContext();
        String token = httpAwareContext.getAuthToken();
        Keyspace keyspace = dataStore.schema().keyspace(keyspaceName);
        if (keyspace == null) {
            return null;
        }
        return KeyspaceFormatter.formatResult(keyspace, environment, this.authorizationService, token);
    }
}

