/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.ddl;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.Persistence;
import io.stargate.db.query.Query;
import io.stargate.db.query.builder.QueryBuilder;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.fetchers.ddl.DdlQueryFetcher;
import io.stargate.graphql.web.HttpAwareContext;

public class DropTypeFetcher
extends DdlQueryFetcher {
    public DropTypeFetcher(Persistence persistence, AuthenticationService authenticationService, AuthorizationService authorizationService) {
        super(persistence, authenticationService, authorizationService);
    }

    @Override
    protected Query<?> buildQuery(DataFetchingEnvironment dataFetchingEnvironment, QueryBuilder builder) throws UnauthorizedException {
        String keyspaceName = (String)dataFetchingEnvironment.getArgument("keyspaceName");
        String typeName = (String)dataFetchingEnvironment.getArgument("typeName");
        HttpAwareContext httpAwareContext = (HttpAwareContext)dataFetchingEnvironment.getContext();
        String token = httpAwareContext.getAuthToken();
        this.authorizationService.authorizeSchemaWrite(token, keyspaceName, null, Scope.DROP);
        Boolean ifExists = (Boolean)dataFetchingEnvironment.getArgument("ifExists");
        return builder.drop().type(keyspaceName, UserDefinedType.reference((String)typeName)).ifExists(ifExists != null && ifExists != false).build();
    }
}

