/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.Persistence;
import io.stargate.graphql.schema.fetchers.ddl.AllKeyspacesFetcher;
import io.stargate.graphql.schema.fetchers.ddl.AlterTableAddFetcher;
import io.stargate.graphql.schema.fetchers.ddl.AlterTableDropFetcher;
import io.stargate.graphql.schema.fetchers.ddl.CreateKeyspaceFetcher;
import io.stargate.graphql.schema.fetchers.ddl.CreateTableFetcher;
import io.stargate.graphql.schema.fetchers.ddl.CreateTypeFetcher;
import io.stargate.graphql.schema.fetchers.ddl.DropKeyspaceFetcher;
import io.stargate.graphql.schema.fetchers.ddl.DropTableFetcher;
import io.stargate.graphql.schema.fetchers.ddl.DropTypeFetcher;
import io.stargate.graphql.schema.fetchers.ddl.SingleKeyspaceFetcher;
import java.util.HashMap;

class DdlSchemaBuilder {
    private final HashMap<String, GraphQLType> objects;
    private final Persistence persistence;
    private AuthenticationService authenticationService;
    private AuthorizationService authorizationService;

    DdlSchemaBuilder(Persistence persistence, AuthenticationService authenticationService, AuthorizationService authorizationService) {
        this.persistence = persistence;
        this.objects = new HashMap();
        this.authenticationService = authenticationService;
        this.authorizationService = authorizationService;
    }

    GraphQLSchema build() {
        return new GraphQLSchema.Builder().mutation(this.buildMutation(this.buildCreateTable(), this.buildAlterTableAdd(), this.buildAlterTableDrop(), this.buildDropTable(), this.buildCreateType(), this.buildDropType(), this.buildCreateKeyspace(), this.buildDropKeyspace())).query(this.buildQuery(this.buildKeyspaceByName(), this.buildKeyspaces())).build();
    }

    private GraphQLFieldDefinition buildAlterTableAdd() {
        return GraphQLFieldDefinition.newFieldDefinition().name("alterTableAdd").argument(GraphQLArgument.newArgument().name("keyspaceName").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("tableName").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("toAdd").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)this.buildColumnInput())))).type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher((DataFetcher)new AlterTableAddFetcher(this.persistence, this.authenticationService, this.authorizationService)).build();
    }

    private GraphQLFieldDefinition buildAlterTableDrop() {
        return GraphQLFieldDefinition.newFieldDefinition().name("alterTableDrop").argument(GraphQLArgument.newArgument().name("keyspaceName").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("tableName").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("toDrop").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)Scalars.GraphQLString)))).type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher((DataFetcher)new AlterTableDropFetcher(this.persistence, this.authenticationService, this.authorizationService)).build();
    }

    private GraphQLFieldDefinition buildDropTable() {
        return GraphQLFieldDefinition.newFieldDefinition().name("dropTable").argument(GraphQLArgument.newArgument().name("keyspaceName").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("tableName").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("ifExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher((DataFetcher)new DropTableFetcher(this.persistence, this.authenticationService, this.authorizationService)).build();
    }

    private GraphQLFieldDefinition buildCreateType() {
        return GraphQLFieldDefinition.newFieldDefinition().name("createType").argument(GraphQLArgument.newArgument().name("keyspaceName").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("typeName").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("fields").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)this.buildColumnInput())))).argument(GraphQLArgument.newArgument().name("ifNotExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher((DataFetcher)new CreateTypeFetcher(this.persistence, this.authenticationService, this.authorizationService)).build();
    }

    private GraphQLFieldDefinition buildDropType() {
        return GraphQLFieldDefinition.newFieldDefinition().name("dropType").argument(GraphQLArgument.newArgument().name("keyspaceName").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("typeName").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("ifExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher((DataFetcher)new DropTypeFetcher(this.persistence, this.authenticationService, this.authorizationService)).build();
    }

    private GraphQLFieldDefinition buildCreateKeyspace() {
        return GraphQLFieldDefinition.newFieldDefinition().name("createKeyspace").description("Creates a new CQL keyspace").argument(GraphQLArgument.newArgument().name("name").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).description("The name of the keyspace")).argument(GraphQLArgument.newArgument().name("ifNotExists").type((GraphQLInputType)Scalars.GraphQLBoolean).description("Whether the operation will succeed if the keyspace already exists. Defaults to false if absent.")).argument(GraphQLArgument.newArgument().name("replicas").type((GraphQLInputType)Scalars.GraphQLInt).description("Enables SimpleStrategy replication with the given replication factor. You must specify either this or 'datacenters', but not both.")).argument(GraphQLArgument.newArgument().name("datacenters").type((GraphQLInputType)GraphQLList.list((GraphQLType)this.buildDataCenterInput())).description("Enables NetworkTopologyStrategy with the given replication factors per DC. (at least one DC must be specified).You must specify either this or 'replicas', but not both.").build()).type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher((DataFetcher)new CreateKeyspaceFetcher(this.persistence, this.authenticationService, this.authorizationService)).build();
    }

    private GraphQLFieldDefinition buildDropKeyspace() {
        return GraphQLFieldDefinition.newFieldDefinition().name("dropKeyspace").description("Drops a CQL keyspace").argument(GraphQLArgument.newArgument().name("name").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).description("The name of the keyspace")).argument(GraphQLArgument.newArgument().name("ifExists").type((GraphQLInputType)Scalars.GraphQLBoolean).description("Whether the operation will succeed if the keyspace does not exist. Defaults to false if absent.")).type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher((DataFetcher)new DropKeyspaceFetcher(this.persistence, this.authenticationService, this.authorizationService)).build();
    }

    private GraphQLObjectType buildQuery(GraphQLFieldDefinition ... defs) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("Query");
        for (GraphQLFieldDefinition def : defs) {
            builder.field(def);
        }
        return builder.build();
    }

    private GraphQLFieldDefinition buildKeyspaceByName() {
        return GraphQLFieldDefinition.newFieldDefinition().name("keyspace").argument(GraphQLArgument.newArgument().name("name").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).type((GraphQLOutputType)this.buildKeyspace()).dataFetcher((DataFetcher)new SingleKeyspaceFetcher(this.persistence, this.authenticationService, this.authorizationService)).build();
    }

    private GraphQLObjectType buildKeyspace() {
        return (GraphQLObjectType)this.register((GraphQLType)GraphQLObjectType.newObject().name("Keyspace").field(GraphQLFieldDefinition.newFieldDefinition().name("dcs").type((GraphQLOutputType)GraphQLList.list((GraphQLType)this.buildDataCenter()))).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("table").argument(GraphQLArgument.newArgument().name("name").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).build()).type((GraphQLOutputType)this.buildTableType())).field(GraphQLFieldDefinition.newFieldDefinition().name("tables").type((GraphQLOutputType)GraphQLList.list((GraphQLType)this.buildTableType()))).field(GraphQLFieldDefinition.newFieldDefinition().name("type").argument(GraphQLArgument.newArgument().name("name").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).build()).type((GraphQLOutputType)this.buildUdtType())).field(GraphQLFieldDefinition.newFieldDefinition().name("types").type((GraphQLOutputType)GraphQLList.list((GraphQLType)this.buildUdtType()))).build());
    }

    private GraphQLObjectType buildTableType() {
        return (GraphQLObjectType)this.register((GraphQLType)GraphQLObjectType.newObject().name("Table").field(GraphQLFieldDefinition.newFieldDefinition().name("columns").type((GraphQLOutputType)GraphQLList.list((GraphQLType)this.buildColumnType()))).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).build());
    }

    private GraphQLObjectType buildUdtType() {
        return (GraphQLObjectType)this.register((GraphQLType)GraphQLObjectType.newObject().name("Type").field(GraphQLFieldDefinition.newFieldDefinition().name("fields").type((GraphQLOutputType)GraphQLList.list((GraphQLType)this.buildFieldType()))).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).build());
    }

    private GraphQLType buildColumnType() {
        return (GraphQLType)this.register((GraphQLType)GraphQLObjectType.newObject().name("Column").field(GraphQLFieldDefinition.newFieldDefinition().name("kind").type((GraphQLOutputType)this.buildColumnKind())).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("type").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)this.buildDataType()))).build());
    }

    private GraphQLType buildFieldType() {
        return (GraphQLType)this.register((GraphQLType)GraphQLObjectType.newObject().name("Field").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("type").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)this.buildDataType()))).build());
    }

    private GraphQLType buildDataType() {
        return (GraphQLType)this.register((GraphQLType)GraphQLObjectType.newObject().name("DataType").field(GraphQLFieldDefinition.newFieldDefinition().name("basic").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)this.buildBasicType()))).field(GraphQLFieldDefinition.newFieldDefinition().name("info").type(this.buildDataTypeInfo())).build());
    }

    private GraphQLOutputType buildDataTypeInfo() {
        return (GraphQLOutputType)this.register((GraphQLType)GraphQLObjectType.newObject().name("DataTypeInfo").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("subTypes").type((GraphQLOutputType)GraphQLList.list((GraphQLType)new GraphQLTypeReference("DataType")))).field(GraphQLFieldDefinition.newFieldDefinition().name("frozen").type((GraphQLOutputType)Scalars.GraphQLBoolean)).build());
    }

    private GraphQLEnumType buildColumnKind() {
        return (GraphQLEnumType)this.register((GraphQLType)GraphQLEnumType.newEnum().name("ColumnKind").value("COMPACT").value("UNKNOWN").value("PARTITION").value("CLUSTERING").value("REGULAR").value("STATIC").build());
    }

    private GraphQLObjectType buildDataCenter() {
        return (GraphQLObjectType)this.register((GraphQLType)GraphQLObjectType.newObject().name("DataCenter").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("replicas").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLInt))).build());
    }

    private GraphQLInputObjectType buildDataCenterInput() {
        return (GraphQLInputObjectType)this.register((GraphQLType)GraphQLInputObjectType.newInputObject().name("DataCenterInput").description("The DC-level replication options passed to 'createKeyspace.datacenters'.").field(GraphQLInputObjectField.newInputObjectField().name("name").description("The name of the datacenter.").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).field(GraphQLInputObjectField.newInputObjectField().name("replicas").description("The replication factor for this datacenter.").type((GraphQLInputType)Scalars.GraphQLInt)).build());
    }

    private GraphQLFieldDefinition buildKeyspaces() {
        return GraphQLFieldDefinition.newFieldDefinition().name("keyspaces").type((GraphQLOutputType)GraphQLList.list((GraphQLType)this.buildKeyspace())).dataFetcher((DataFetcher)new AllKeyspacesFetcher(this.persistence, this.authenticationService, this.authorizationService)).build();
    }

    private GraphQLObjectType buildMutation(GraphQLFieldDefinition ... defs) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("Mutation");
        for (GraphQLFieldDefinition def : defs) {
            builder.field(def);
        }
        return builder.build();
    }

    private GraphQLFieldDefinition buildCreateTable() {
        return GraphQLFieldDefinition.newFieldDefinition().name("createTable").argument(GraphQLArgument.newArgument().name("keyspaceName").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("tableName").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("partitionKeys").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)this.buildColumnInput())))).argument(GraphQLArgument.newArgument().name("clusteringKeys").type((GraphQLInputType)GraphQLList.list((GraphQLType)this.buildClusteringKeyInput()))).argument(GraphQLArgument.newArgument().name("values").type((GraphQLInputType)GraphQLList.list((GraphQLType)this.buildColumnInput()))).argument(GraphQLArgument.newArgument().name("ifNotExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher((DataFetcher)new CreateTableFetcher(this.persistence, this.authenticationService, this.authorizationService)).build();
    }

    private GraphQLInputObjectType buildClusteringKeyInput() {
        return (GraphQLInputObjectType)this.register((GraphQLType)GraphQLInputObjectType.newInputObject().name("ClusteringKeyInput").field(GraphQLInputObjectField.newInputObjectField().name("name").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).field(GraphQLInputObjectField.newInputObjectField().name("type").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)this.buildDataTypeInput()))).field(GraphQLInputObjectField.newInputObjectField().name("order").type((GraphQLInputType)Scalars.GraphQLString)).build());
    }

    private GraphQLInputObjectType buildColumnInput() {
        return (GraphQLInputObjectType)this.register((GraphQLType)GraphQLInputObjectType.newInputObject().name("ColumnInput").field(GraphQLInputObjectField.newInputObjectField().name("name").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).field(GraphQLInputObjectField.newInputObjectField().name("type").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)this.buildDataTypeInput()))).build());
    }

    private GraphQLInputObjectType buildDataTypeInput() {
        return (GraphQLInputObjectType)this.register((GraphQLType)GraphQLInputObjectType.newInputObject().name("DataTypeInput").field(GraphQLInputObjectField.newInputObjectField().name("info").type((GraphQLInputType)this.buildDataTypeInfoInput())).field(GraphQLInputObjectField.newInputObjectField().name("basic").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)this.buildBasicType()))).build());
    }

    private GraphQLInputType buildBasicType() {
        return (GraphQLInputType)this.register((GraphQLType)GraphQLEnumType.newEnum().name("BasicType").value("CUSTOM").value("INT").value("TIMEUUID").value("TIMESTAMP").value("UDT").value("BIGINT").value("TIME").value("DURATION").value("VARINT").value("UUID").value("BOOLEAN").value("TINYINT").value("SMALLINT").value("INET").value("ASCII").value("DECIMAL").value("BLOB").value("LIST").value("MAP").value("VARCHAR").value("TUPLE").value("DOUBLE").value("COUNTER").value("DATE").value("TEXT").value("FLOAT").value("SET").build());
    }

    private GraphQLInputObjectType buildDataTypeInfoInput() {
        return (GraphQLInputObjectType)this.register((GraphQLType)GraphQLInputObjectType.newInputObject().name("DataTypeInfoInput").field(GraphQLInputObjectField.newInputObjectField().name("subTypes").type((GraphQLInputType)GraphQLList.list((GraphQLType)new GraphQLTypeReference("DataTypeInput")))).field(GraphQLInputObjectField.newInputObjectField().name("name").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("frozen").type((GraphQLInputType)Scalars.GraphQLBoolean).build()).build());
    }

    private <T> T register(GraphQLType object) {
        String name = this.getName(object);
        if (name == null) {
            throw new RuntimeException("Schema object has no name" + object);
        }
        GraphQLType o = this.objects.get(name);
        if (o == null) {
            this.objects.put(name, object);
            return (T)object;
        }
        return (T)o;
    }

    private String getName(GraphQLType object) {
        if (object instanceof GraphQLInputObjectType) {
            return ((GraphQLInputObjectType)object).getName();
        }
        if (object instanceof GraphQLObjectType) {
            return ((GraphQLObjectType)object).getName();
        }
        if (object instanceof GraphQLEnumType) {
            return ((GraphQLEnumType)object).getName();
        }
        return null;
    }
}

