/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.framework.Bundle;

@Produces(value={"text/html"})
@Path(value="/playground")
@Singleton
public class PlaygroundResource {
    private final String playgroundFile;

    @Inject
    public PlaygroundResource(Bundle bundle) throws IOException {
        URL entry = bundle.getEntry("/playground.html");
        this.playgroundFile = new BufferedReader(new InputStreamReader(entry.openConnection().getInputStream())).lines().collect(Collectors.joining("\n"));
    }

    @GET
    public Response get(@Context HttpServletRequest request) {
        String token = request.getHeader("x-cassandra-token");
        String formattedPlaygroundFile = this.playgroundFile.replaceFirst("AUTHENTICATION_TOKEN", token == null ? "" : token);
        return Response.ok((Object)formattedPlaygroundFile).build();
    }
}

