/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web;

import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;

public class HttpAwareContext {
    private HttpServletRequest request;
    private final BatchContext batchContext = new BatchContext();

    public HttpAwareContext(HttpServletRequest request) {
        this.request = request;
    }

    public String getAuthToken() {
        return this.request.getHeader("X-Cassandra-Token");
    }

    public BatchContext getBatchContext() {
        return this.batchContext;
    }

    public static class BatchContext {
        private final List<String> statements = new ArrayList<String>();
        private final CompletableFuture<ResultSet> executionFuture = new CompletableFuture();
        private AtomicReference<DataStore> dataStore = new AtomicReference();

        public CompletableFuture<ResultSet> getExecutionFuture() {
            return this.executionFuture;
        }

        public synchronized List<String> getStatements() {
            return this.statements;
        }

        public void setExecutionResult(CompletableFuture<ResultSet> result) {
            result.whenComplete((r, e) -> {
                if (e != null) {
                    this.executionFuture.completeExceptionally((Throwable)e);
                } else {
                    this.executionFuture.complete((ResultSet)r);
                }
            });
        }

        public void setExecutionResult(Exception ex) {
            this.executionFuture.completeExceptionally(ex);
        }

        public synchronized int add(String query) {
            this.statements.add(query);
            return this.statements.size();
        }

        public boolean setDataStore(DataStore dataStore) {
            return this.dataStore.getAndSet(dataStore) != null;
        }

        public Optional<DataStore> getDataStore() {
            return Optional.ofNullable(this.dataStore.get());
        }
    }
}

