/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.NameMapping;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class DataTypeMapping {
    DataTypeMapping() {
    }

    static Term toCqlTerm(Column.ColumnType type, Object value, NameMapping nameMapping) {
        StringBuilder raw = new StringBuilder();
        DataTypeMapping.format(type, value, nameMapping, raw);
        return QueryBuilder.raw((String)raw.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void format(Column.ColumnType type, Object value, NameMapping nameMapping, StringBuilder out) {
        if (type.isCollection()) {
            if (type.rawType() == Column.Type.List) {
                DataTypeMapping.formatElements((Column.ColumnType)type.parameters().get(0), (Collection)value, '[', ']', nameMapping, out);
                return;
            } else if (type.rawType() == Column.Type.Set) {
                DataTypeMapping.formatElements((Column.ColumnType)type.parameters().get(0), (Collection)value, '{', '}', nameMapping, out);
                return;
            } else {
                if (type.rawType() != Column.Type.Map) throw new AssertionError((Object)("Invalid collection type " + type));
                DataTypeMapping.formatMap(type, value, nameMapping, out);
            }
            return;
        } else if (type.isUserDefined()) {
            DataTypeMapping.formatUdt((UserDefinedType)type, value, nameMapping, out);
            return;
        } else if (type.isTuple()) {
            DataTypeMapping.formatTuple(type, value, nameMapping, out);
            return;
        } else {
            TypeCodec codec = type.codec();
            out.append(codec.format(value));
        }
    }

    private static void formatElements(Column.ColumnType elementType, Collection<?> elements, char startChar, char endChar, NameMapping nameMapping, StringBuilder out) {
        out.append(startChar);
        boolean first = true;
        for (Object element : elements) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            DataTypeMapping.format(elementType, element, nameMapping, out);
        }
        out.append(endChar);
    }

    private static void formatMap(Column.ColumnType type, Object value, NameMapping nameMapping, StringBuilder out) {
        out.append('{');
        Collection entries = (Collection)value;
        Column.ColumnType keyType = (Column.ColumnType)type.parameters().get(0);
        Column.ColumnType valueType = (Column.ColumnType)type.parameters().get(1);
        boolean first = true;
        for (Map entry : entries) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            DataTypeMapping.format(keyType, entry.get("key"), nameMapping, out);
            out.append(':');
            DataTypeMapping.format(valueType, entry.get("value"), nameMapping, out);
        }
        out.append('}');
    }

    private static void formatUdt(UserDefinedType type, Object value, NameMapping nameMapping, StringBuilder out) {
        type = type.frozen(false);
        out.append('{');
        Map object = (Map)value;
        boolean first = true;
        for (Map.Entry entry : object.entrySet()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            String fieldName = nameMapping.getCqlName(type, (String)entry.getKey());
            Column.ColumnType fieldType = type.fieldType(fieldName);
            out.append('\"').append(fieldName).append("\":");
            DataTypeMapping.format(fieldType, entry.getValue(), nameMapping, out);
        }
        out.append('}');
    }

    private static void formatTuple(Column.ColumnType type, Object value, NameMapping nameMapping, StringBuilder out) {
        out.append('(');
        Map mapValue = (Map)value;
        List subTypes = type.parameters();
        for (int i = 0; i < subTypes.size(); ++i) {
            Object item = mapValue.get("item" + i);
            if (i > 0) {
                out.append(',');
            }
            DataTypeMapping.format((Column.ColumnType)subTypes.get(i), item, nameMapping, out);
        }
        out.append(')');
    }

    static Map<String, Object> toGraphQLValue(NameMapping nameMapping, Table table, Row row) {
        List columns = row.columns();
        HashMap<String, Object> map = new HashMap<String, Object>(columns.size());
        for (Column column : columns) {
            String graphqlName = nameMapping.getGraphqlName(table, column);
            if (graphqlName == null || row.isNull(column.name())) continue;
            map.put(graphqlName, DataTypeMapping.toGraphQLValue(nameMapping, column, row));
        }
        return map;
    }

    private static Object toGraphQLValue(NameMapping nameMapping, Column column, Row row) {
        Object dbValue = row.getObject(column.name());
        return DataTypeMapping.toGraphQLValue(nameMapping, column.type(), dbValue);
    }

    private static Object toGraphQLValue(NameMapping nameMapping, Column.ColumnType type, Object dbValue) {
        if (dbValue == null) {
            return null;
        }
        if (type.isCollection()) {
            if (type.rawType() == Column.Type.List || type.rawType() == Column.Type.Set) {
                Collection dbCollection = (Collection)dbValue;
                return dbCollection.stream().map(item -> DataTypeMapping.toGraphQLValue(nameMapping, (Column.ColumnType)type.parameters().get(0), item)).collect(Collectors.toList());
            }
            if (type.rawType() == Column.Type.Map) {
                Map dbMap = (Map)dbValue;
                Column.ColumnType keyType = (Column.ColumnType)type.parameters().get(0);
                Column.ColumnType valueType = (Column.ColumnType)type.parameters().get(1);
                return dbMap.entrySet().stream().map(e -> {
                    HashMap<String, Object> m = new HashMap<String, Object>(2);
                    m.put("key", DataTypeMapping.toGraphQLValue(nameMapping, keyType, e.getKey()));
                    m.put("value", DataTypeMapping.toGraphQLValue(nameMapping, valueType, e.getValue()));
                    return m;
                }).collect(Collectors.toList());
            }
            throw new AssertionError((Object)("Invalid collection type " + type));
        }
        if (type.isUserDefined()) {
            UserDefinedType udt = (UserDefinedType)type.frozen(false);
            UdtValue udtValue = (UdtValue)dbValue;
            HashMap<String, Object> result = new HashMap<String, Object>(udt.columns().size());
            for (Column column : udt.columns()) {
                Object dbFieldValue = udtValue.getObject(CqlIdentifier.fromInternal((String)column.name()));
                String graphQlFieldName = nameMapping.getGraphqlName(udt, column);
                if (dbFieldValue == null || graphQlFieldName == null) continue;
                Object graphQlFieldValue = DataTypeMapping.toGraphQLValue(nameMapping, column.type(), dbFieldValue);
                result.put(graphQlFieldName, graphQlFieldValue);
            }
            return result;
        }
        if (type.isTuple()) {
            TupleValue tuple = (TupleValue)dbValue;
            HashMap<String, Object> result = new HashMap<String, Object>(tuple.size());
            for (int i = 0; i < tuple.size(); ++i) {
                result.put("item" + i, DataTypeMapping.toGraphQLValue(nameMapping, (Column.ColumnType)type.parameters().get(i), tuple.getObject(i)));
            }
            return result;
        }
        return dbValue;
    }
}

