/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.ddl;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.graphql.schema.fetchers.CassandraFetcher;
import java.util.List;
import java.util.Map;

public abstract class DdlQueryFetcher
extends CassandraFetcher<Boolean> {
    protected DdlQueryFetcher(Persistence persistence, AuthenticationService authenticationService) {
        super(persistence, authenticationService);
    }

    @Override
    protected Boolean get(DataFetchingEnvironment environment, DataStore dataStore) throws Exception {
        dataStore.query(this.getQuery(environment), new Object[0]).get();
        return true;
    }

    abstract String getQuery(DataFetchingEnvironment var1);

    protected DataType decodeType(Object typeObject) {
        Map type = (Map)typeObject;
        String basic = (String)type.get("basic");
        Map info = (Map)type.get("info");
        String name = info == null ? null : (String)info.get("name");
        List subTypes = info == null ? null : (List)info.get("subTypes");
        boolean frozen = info != null && info.containsKey("frozen") && (Boolean)info.get("frozen") != false;
        switch (basic) {
            case "INT": {
                return DataTypes.INT;
            }
            case "INET": {
                return DataTypes.INET;
            }
            case "TIMEUUID": {
                return DataTypes.TIMEUUID;
            }
            case "TIMESTAMP": {
                return DataTypes.TIMESTAMP;
            }
            case "BIGINT": {
                return DataTypes.BIGINT;
            }
            case "TIME": {
                return DataTypes.TIME;
            }
            case "DURATION": {
                return DataTypes.DURATION;
            }
            case "VARINT": {
                return DataTypes.VARINT;
            }
            case "UUID": {
                return DataTypes.UUID;
            }
            case "BOOLEAN": {
                return DataTypes.BOOLEAN;
            }
            case "TINYINT": {
                return DataTypes.TINYINT;
            }
            case "SMALLINT": {
                return DataTypes.SMALLINT;
            }
            case "ASCII": {
                return DataTypes.ASCII;
            }
            case "DECIMAL": {
                return DataTypes.DECIMAL;
            }
            case "BLOB": {
                return DataTypes.BLOB;
            }
            case "VARCHAR": 
            case "TEXT": {
                return DataTypes.TEXT;
            }
            case "DOUBLE": {
                return DataTypes.DOUBLE;
            }
            case "COUNTER": {
                return DataTypes.COUNTER;
            }
            case "DATE": {
                return DataTypes.DATE;
            }
            case "FLOAT": {
                return DataTypes.FLOAT;
            }
            case "LIST": {
                if (info == null) {
                    throw new IllegalArgumentException("List type should contain an 'info' field specifying the sub type");
                }
                if (subTypes == null || subTypes.size() != 1) {
                    throw new IllegalArgumentException("List sub types should contain 1 item");
                }
                return DataTypes.listOf((DataType)this.decodeType(subTypes.get(0)), (boolean)frozen);
            }
            case "SET": {
                if (info == null) {
                    throw new IllegalArgumentException("Set type should contain an 'info' field specifying the sub type");
                }
                if (subTypes == null || subTypes.size() != 1) {
                    throw new IllegalArgumentException("Set sub types should contain 1 item");
                }
                subTypes = (List)info.get("subTypes");
                return DataTypes.setOf((DataType)this.decodeType(subTypes.get(0)), (boolean)frozen);
            }
            case "MAP": {
                if (info == null) {
                    throw new IllegalArgumentException("Map type should contain an 'info' field specifying the sub types");
                }
                if (subTypes == null || subTypes.size() != 2) {
                    throw new IllegalArgumentException("Map sub types should contain 2 items");
                }
                return DataTypes.mapOf((DataType)this.decodeType(subTypes.get(0)), (DataType)this.decodeType(subTypes.get(1)), (boolean)frozen);
            }
            case "UDT": {
                if (name == null) {
                    throw new IllegalArgumentException("UDT type should contain an 'info' field specifying the UDT name");
                }
                return SchemaBuilder.udt((CqlIdentifier)CqlIdentifier.fromInternal((String)name), (boolean)frozen);
            }
            case "TUPLE": {
                if (info == null) {
                    throw new IllegalArgumentException("TUPLE type should contain an 'info' field specifying the sub types");
                }
                if (subTypes.isEmpty()) {
                    throw new IllegalArgumentException("TUPLE type should have at least one sub type");
                }
                DataType[] decodedSubTypes = new DataType[subTypes.size()];
                for (int i = 0; i < subTypes.size(); ++i) {
                    decodedSubTypes[i] = this.decodeType(subTypes.get(i));
                }
                return DataTypes.tupleOf((DataType[])decodedSubTypes);
            }
        }
        throw new RuntimeException(String.format("Data type %s is not supported", basic));
    }
}

