/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema;

import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import io.stargate.db.schema.Column;
import io.stargate.graphql.schema.FieldInputTypeCache;
import io.stargate.graphql.schema.FieldTypeCache;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.FilterOperator;

public class FieldFilterInputTypeCache
extends FieldTypeCache<GraphQLInputType> {
    private final FieldInputTypeCache inputTypeCache;

    FieldFilterInputTypeCache(FieldInputTypeCache inputTypeCache, NameMapping nameMapping) {
        super(nameMapping);
        this.inputTypeCache = inputTypeCache;
    }

    @Override
    protected GraphQLInputType compute(Column.ColumnType columnType) {
        GraphQLInputType gqlInputType = (GraphQLInputType)this.inputTypeCache.get(columnType);
        if (columnType.isMap()) {
            return this.mapFilter(gqlInputType);
        }
        if (columnType.isList() || columnType.isSet()) {
            return this.listFilter(gqlInputType);
        }
        return FieldFilterInputTypeCache.singleElementFilter(gqlInputType);
    }

    private GraphQLInputType mapFilter(GraphQLInputType gqlInputType) {
        GraphQLList gqlMapType = (GraphQLList)gqlInputType;
        GraphQLInputObjectType entryType = (GraphQLInputObjectType)gqlMapType.getWrappedType();
        GraphQLNonNull nonNullkeyType = (GraphQLNonNull)entryType.getField("key").getType();
        GraphQLInputType keyType = (GraphQLInputType)nonNullkeyType.getWrappedType();
        GraphQLInputType valueType = entryType.getField("value").getType();
        GraphQLInputObjectType.Builder builder = FieldFilterInputTypeCache.basicComparisons(gqlInputType);
        builder.field(FilterOperator.CONTAINS_KEY.buildField(keyType));
        builder.field(FilterOperator.CONTAINS.buildField(valueType));
        builder.field(FilterOperator.CONTAINS_ENTRY.buildField((GraphQLInputType)entryType));
        return builder.build();
    }

    private GraphQLInputType listFilter(GraphQLInputType gqlInputType) {
        GraphQLList gqlListType = (GraphQLList)gqlInputType;
        GraphQLInputType elementType = (GraphQLInputType)gqlListType.getWrappedType();
        GraphQLInputObjectType.Builder builder = FieldFilterInputTypeCache.basicComparisons(gqlInputType);
        builder.field(FilterOperator.CONTAINS.buildField(elementType));
        return builder.build();
    }

    private static GraphQLInputObjectType singleElementFilter(GraphQLInputType gqlInputType) {
        return FieldFilterInputTypeCache.basicComparisons(gqlInputType).build();
    }

    private static GraphQLInputObjectType.Builder basicComparisons(GraphQLInputType gqlInputType) {
        return GraphQLInputObjectType.newInputObject().name(FieldFilterInputTypeCache.buildFilterName(gqlInputType)).field(FilterOperator.EQUAL.buildField(gqlInputType)).field(FilterOperator.NOT_EQUAL.buildField(gqlInputType)).field(FilterOperator.GREATER_THAN.buildField(gqlInputType)).field(FilterOperator.GREATER_THAN_EQUAL.buildField(gqlInputType)).field(FilterOperator.LESS_THAN.buildField(gqlInputType)).field(FilterOperator.LESS_THAN_EQUAL.buildField(gqlInputType)).field(FilterOperator.IN.buildField(gqlInputType));
    }

    private static String buildFilterName(GraphQLInputType gqlInputType) {
        return FieldFilterInputTypeCache.format(gqlInputType) + "FilterInput";
    }

    private static String format(GraphQLInputType gqlInputType) {
        if (gqlInputType instanceof GraphQLScalarType) {
            return ((GraphQLScalarType)gqlInputType).getName();
        }
        if (gqlInputType instanceof GraphQLList) {
            GraphQLList gqlListType = (GraphQLList)gqlInputType;
            GraphQLInputType elementType = (GraphQLInputType)gqlListType.getWrappedType();
            return "List" + FieldFilterInputTypeCache.format(elementType);
        }
        if (gqlInputType instanceof GraphQLInputObjectType) {
            String name = ((GraphQLInputObjectType)gqlInputType).getName();
            if (name.endsWith("Input")) {
                name = name.substring(0, name.length() - 5);
            }
            return name;
        }
        throw new IllegalStateException("Unexpected input type " + gqlInputType);
    }
}

