/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql;

import io.stargate.auth.AuthenticationService;
import io.stargate.core.activator.BaseActivator;
import io.stargate.core.metrics.api.Metrics;
import io.stargate.db.Persistence;
import io.stargate.graphql.web.DropwizardServer;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlActivator
extends BaseActivator {
    private static final Logger LOG = LoggerFactory.getLogger(GraphqlActivator.class);
    private static final String AUTH_IDENTIFIER = System.getProperty("stargate.auth_id", "AuthTableBasedService");
    private static final String PERSISTENCE_IDENTIFIER = System.getProperty("stargate.persistence_id", "CassandraPersistence");
    private BaseActivator.ServicePointer<AuthenticationService> authentication = BaseActivator.ServicePointer.create(AuthenticationService.class, (String)"AuthIdentifier", (String)AUTH_IDENTIFIER);
    private BaseActivator.ServicePointer<Persistence> persistence = BaseActivator.ServicePointer.create(Persistence.class, (String)"Identifier", (String)PERSISTENCE_IDENTIFIER);
    private BaseActivator.ServicePointer<Metrics> metrics = BaseActivator.ServicePointer.create(Metrics.class);
    @GuardedBy(value="this")
    private DropwizardServer server;

    public GraphqlActivator() {
        super("GraphQL");
    }

    @Nullable
    protected BaseActivator.ServiceAndProperties createService() {
        this.maybeStartService((Persistence)this.persistence.get(), (Metrics)this.metrics.get(), (AuthenticationService)this.authentication.get());
        return null;
    }

    protected void stopService() {
        this.maybeStopService();
    }

    protected List<BaseActivator.ServicePointer<?>> dependencies() {
        return Arrays.asList(this.persistence, this.metrics, this.authentication);
    }

    private synchronized void maybeStartService(Persistence persistence, Metrics metrics, AuthenticationService authentication) {
        if (this.server == null) {
            try {
                this.server = new DropwizardServer(persistence, authentication, metrics);
                LOG.info("Starting GraphQL");
                this.server.run("server", "config.yaml");
            }
            catch (Exception e) {
                LOG.error("Unexpected error while stopping GraphQL", (Throwable)e);
            }
        }
    }

    private synchronized void maybeStopService() {
        if (this.server != null) {
            try {
                LOG.info("Stopping GraphQL");
                this.server.stop();
            }
            catch (Exception e) {
                LOG.error("Unexpected error while stopping GraphQL", (Throwable)e);
            }
        }
    }
}

