/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web;

import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.schema.GraphQLSchema;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.EventListener;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.SchemaFactory;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlCache
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(GraphqlCache.class);
    private final Persistence persistence;
    private final AuthenticationService authenticationService;
    private final GraphQL ddlGraphql;
    private final String defaultKeyspace;
    private final ConcurrentMap<String, DmlGraphqlReference> dmlGraphqls;

    GraphqlCache(Persistence persistence, AuthenticationService authenticationService) {
        this.persistence = persistence;
        this.authenticationService = authenticationService;
        this.ddlGraphql = GraphqlCache.newGraphql(SchemaFactory.newDdlSchema(persistence, authenticationService));
        DataStore dataStore = DataStore.create((Persistence)persistence);
        this.defaultKeyspace = GraphqlCache.findDefaultKeyspace(dataStore);
        this.dmlGraphqls = GraphqlCache.initDmlGraphqls(persistence, dataStore, authenticationService);
        persistence.registerEventListener((EventListener)this);
    }

    public GraphQL getDdl() {
        return this.ddlGraphql;
    }

    public GraphQL getDml(String keyspace) {
        DmlGraphqlReference ref = (DmlGraphqlReference)this.dmlGraphqls.get(keyspace);
        return ref == null ? null : ref.get();
    }

    public GraphQL getDefaultDml() {
        return this.defaultKeyspace == null ? null : this.getDml(this.defaultKeyspace);
    }

    private static String findDefaultKeyspace(DataStore dataStore) {
        try {
            CompletableFuture query = dataStore.query("select writetime(durable_writes) as wt, keyspace_name from system_schema.keyspaces", ConsistencyLevel.LOCAL_QUORUM, new Object[0]);
            ResultSet resultSet = (ResultSet)query.get();
            Column writetimeColumn = Column.create((String)"wt", (Column.ColumnType)Column.Type.Counter);
            Optional<Row> first = resultSet.rows().stream().filter(r -> !r.isNull("wt")).filter(r -> r.getLong(writetimeColumn.name()) > 0L).filter(r -> {
                String keyspaceName = r.getString("keyspace_name");
                return !keyspaceName.equals("system") && !keyspaceName.equals("data_endpoint_auth") && !keyspaceName.equals("solr_admin") && !keyspaceName.startsWith("system_") && !keyspaceName.startsWith("dse_");
            }).min(Comparator.comparing(r -> r.getLong(writetimeColumn.name())));
            String defaultKeyspace = first.map(row -> row.getString("keyspace_name")).orElse(null);
            LOG.debug("Using default keyspace {}", (Object)defaultKeyspace);
            return defaultKeyspace;
        }
        catch (Exception e) {
            LOG.warn("Unable to get default keyspace", (Throwable)e);
            return null;
        }
    }

    private static ConcurrentMap<String, DmlGraphqlReference> initDmlGraphqls(Persistence persistence, DataStore dataStore, AuthenticationService authenticationService) {
        ConcurrentHashMap<String, DmlGraphqlReference> map = new ConcurrentHashMap<String, DmlGraphqlReference>();
        for (Keyspace keyspace : dataStore.schema().keyspaces()) {
            String keyspaceName = keyspace.name();
            LOG.debug("Prepare GraphQL schema for {}", (Object)keyspaceName);
            map.put(keyspaceName, new DmlGraphqlReference(keyspace, persistence, authenticationService));
        }
        return map;
    }

    private void addOrReplaceDmlGraphql(String keyspaceName, String reason, String ... reasonArguments) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Refreshing GraphQL schema for keyspace {} because {}", (Object)keyspaceName, (Object)String.format(reason, reasonArguments));
        }
        try {
            DataStore dataStore = DataStore.create((Persistence)this.persistence);
            Keyspace keyspace = dataStore.schema().keyspace(keyspaceName);
            if (keyspace == null) {
                LOG.debug("Removing GraphQL schema for keyspace {} because it was dropped", (Object)keyspaceName);
                this.dmlGraphqls.remove(keyspaceName);
            } else {
                this.dmlGraphqls.put(keyspaceName, new DmlGraphqlReference(keyspace, this.persistence, this.authenticationService));
            }
            LOG.debug("Done refreshing GraphQL schema for keyspace {}", (Object)keyspaceName);
        }
        catch (Exception e) {
            LOG.error("Error while refreshing GraphQL schema for keyspace {}", (Object)keyspaceName, (Object)e);
        }
    }

    public void onCreateKeyspace(String keyspaceName) {
        this.addOrReplaceDmlGraphql(keyspaceName, "it was created", new String[0]);
    }

    public void onDropKeyspace(String keyspaceName) {
        DmlGraphqlReference removed = (DmlGraphqlReference)this.dmlGraphqls.remove(keyspaceName);
        if (removed != null) {
            LOG.debug("Removing GraphQL schema for keyspace {} because it was dropped", (Object)keyspaceName);
        }
    }

    public void onCreateTable(String keyspaceName, String table) {
        this.addOrReplaceDmlGraphql(keyspaceName, "table %s was created", table);
    }

    public void onCreateView(String keyspaceName, String view) {
        this.addOrReplaceDmlGraphql(keyspaceName, "view %s was created", view);
    }

    public void onCreateType(String keyspaceName, String type) {
        this.addOrReplaceDmlGraphql(keyspaceName, "type %s was created", type);
    }

    public void onCreateFunction(String keyspaceName, String function, List<String> argumentTypes) {
        this.addOrReplaceDmlGraphql(keyspaceName, "function %s was created", function);
    }

    public void onCreateAggregate(String keyspaceName, String aggregate, List<String> argumentTypes) {
        this.addOrReplaceDmlGraphql(keyspaceName, "aggregate %s was created", aggregate);
    }

    public void onAlterTable(String keyspaceName, String table) {
        this.addOrReplaceDmlGraphql(keyspaceName, "table %s was altered", table);
    }

    public void onAlterView(String keyspaceName, String view) {
        this.addOrReplaceDmlGraphql(keyspaceName, "view %s was altered", view);
    }

    public void onAlterType(String keyspaceName, String type) {
        this.addOrReplaceDmlGraphql(keyspaceName, "type %s was altered", type);
    }

    public void onAlterFunction(String keyspaceName, String function, List<String> argumentTypes) {
        this.addOrReplaceDmlGraphql(keyspaceName, "function %s was altered", function);
    }

    public void onAlterAggregate(String keyspaceName, String aggregate, List<String> argumentTypes) {
        this.addOrReplaceDmlGraphql(keyspaceName, "aggregate %s was altered", aggregate);
    }

    public void onDropTable(String keyspaceName, String table) {
        this.addOrReplaceDmlGraphql(keyspaceName, "table %s was dropped", table);
    }

    public void onDropView(String keyspaceName, String view) {
        this.addOrReplaceDmlGraphql(keyspaceName, "view %s was dropped", view);
    }

    public void onDropType(String keyspaceName, String type) {
        this.addOrReplaceDmlGraphql(keyspaceName, "type %s was dropped", type);
    }

    public void onDropFunction(String keyspaceName, String function, List<String> argumentTypes) {
        this.addOrReplaceDmlGraphql(keyspaceName, "function %s was dropped", function);
    }

    public void onDropAggregate(String keyspaceName, String aggregate, List<String> argumentTypes) {
        this.addOrReplaceDmlGraphql(keyspaceName, "aggregate %s was dropped", aggregate);
    }

    private static GraphQL newGraphql(GraphQLSchema schema) {
        return GraphQL.newGraphQL((GraphQLSchema)schema).mutationExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
    }

    static class DmlGraphqlReference {
        private final Keyspace keyspace;
        private final Persistence persistence;
        private final AuthenticationService authenticationService;
        private volatile GraphQL graphql;

        DmlGraphqlReference(Keyspace keyspace, Persistence persistence, AuthenticationService authenticationService) {
            this.keyspace = keyspace;
            this.persistence = persistence;
            this.authenticationService = authenticationService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        GraphQL get() {
            GraphQL result = this.graphql;
            if (result != null) {
                return result;
            }
            DmlGraphqlReference dmlGraphqlReference = this;
            synchronized (dmlGraphqlReference) {
                if (this.graphql == null) {
                    this.graphql = GraphqlCache.newGraphql(SchemaFactory.newDmlSchema(this.persistence, this.authenticationService, this.keyspace));
                }
                return this.graphql;
            }
        }
    }
}

