/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.types.scalars;

import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigDecimal;
import java.math.BigInteger;

class FloatCoercing
implements Coercing<Float, Float> {
    static FloatCoercing INSTANCE = new FloatCoercing();

    private FloatCoercing() {
    }

    public Float serialize(Object dataFetcherResult) throws CoercingSerializeException {
        return (Float)dataFetcherResult;
    }

    public Float parseValue(Object input) throws CoercingParseValueException {
        if (input instanceof Number) {
            return Float.valueOf(((Number)input).floatValue());
        }
        throw new CoercingParseLiteralException("Expected an integer or float literal");
    }

    public Float parseLiteral(Object input) throws CoercingParseLiteralException {
        if (input instanceof IntValue) {
            BigInteger bi = ((IntValue)input).getValue();
            return Float.valueOf(bi.floatValue());
        }
        if (input instanceof FloatValue) {
            BigDecimal bd = ((FloatValue)input).getValue();
            return Float.valueOf(bd.floatValue());
        }
        throw new CoercingParseLiteralException("Expected an integer or float literal");
    }
}

