/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.google.common.collect.ImmutableMap;
import graphql.GraphQLException;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.DmlFetcher;
import io.stargate.graphql.web.HttpAwareContext;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public abstract class MutationFetcher
extends DmlFetcher<CompletableFuture<Map<String, Object>>> {
    protected MutationFetcher(Table table, NameMapping nameMapping, Persistence persistence, AuthenticationService authenticationService) {
        super(table, nameMapping, persistence, authenticationService);
    }

    @Override
    protected CompletableFuture<Map<String, Object>> get(DataFetchingEnvironment environment, DataStore dataStore) {
        String statement = null;
        Exception buildException = null;
        try {
            statement = this.buildStatement(environment, dataStore);
        }
        catch (Exception e) {
            buildException = e;
        }
        OperationDefinition operation = environment.getOperationDefinition();
        if (operation.getDirectives().stream().anyMatch(d -> d.getName().equals("atomic")) && operation.getSelectionSet().getSelections().size() > 1) {
            return this.executeAsBatch(environment, dataStore, statement, buildException);
        }
        if (buildException != null) {
            CompletableFuture<Map<String, Object>> f = new CompletableFuture<Map<String, Object>>();
            f.completeExceptionally(buildException);
            return f;
        }
        return dataStore.query(statement, new Object[0]).thenApply(rs -> ImmutableMap.of((Object)"value", (Object)environment.getArgument("value")));
    }

    private CompletableFuture<Map<String, Object>> executeAsBatch(DataFetchingEnvironment environment, DataStore dataStore, String statement, Exception buildException) {
        boolean dataStoreAlreadySet;
        int selections = environment.getOperationDefinition().getSelectionSet().getSelections().size();
        HttpAwareContext context = (HttpAwareContext)environment.getContext();
        HttpAwareContext.BatchContext batchContext = context.getBatchContext();
        if (environment.getArgument("options") != null && (dataStoreAlreadySet = batchContext.setDataStore(dataStore))) {
            buildException = new GraphQLException("options can only de defined once in an @atomic mutation selection");
        }
        if (buildException != null) {
            batchContext.setExecutionResult(buildException);
        } else if (batchContext.add(statement) == selections) {
            DataStore batchDataStore = batchContext.getDataStore().orElse(dataStore);
            batchContext.setExecutionResult(batchDataStore.batch(batchContext.getStatements()));
        }
        return batchContext.getExecutionFuture().thenApply(v -> ImmutableMap.of((Object)"value", (Object)environment.getArgument("value")));
    }

    protected abstract String buildStatement(DataFetchingEnvironment var1, DataStore var2);
}

