/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.base.Preconditions;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.MutationFetcher;
import java.util.LinkedHashMap;
import java.util.Map;

public class InsertMutationFetcher
extends MutationFetcher {
    public InsertMutationFetcher(Table table, NameMapping nameMapping, Persistence persistence, AuthenticationService authenticationService) {
        super(table, nameMapping, persistence, authenticationService);
    }

    @Override
    protected String buildStatement(DataFetchingEnvironment environment, DataStore dataStore) {
        Map options;
        RegularInsert insert = QueryBuilder.insertInto((CqlIdentifier)this.keyspaceId, (CqlIdentifier)this.tableId).valuesByIds(this.buildInsertValues(environment));
        if (environment.containsArgument("ifNotExists") && environment.getArgument("ifNotExists") != null && ((Boolean)environment.getArgument("ifNotExists")).booleanValue()) {
            insert = insert.ifNotExists();
        }
        if (environment.containsArgument("options") && environment.getArgument("options") != null && (options = (Map)environment.getArgument("options")).containsKey("ttl") && options.get("ttl") != null) {
            insert = insert.usingTtl(((Integer)options.get("ttl")).intValue());
        }
        return insert.asCql();
    }

    private Map<CqlIdentifier, Term> buildInsertValues(DataFetchingEnvironment environment) {
        Map value = (Map)environment.getArgument("value");
        Preconditions.checkNotNull((Object)value, (Object)"Insert statement must contain at least one field");
        LinkedHashMap<CqlIdentifier, Term> insertMap = new LinkedHashMap<CqlIdentifier, Term>();
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.getColumn(this.table, (String)entry.getKey());
            insertMap.put(CqlIdentifier.fromInternal((String)column.name()), this.toCqlTerm(column, entry.getValue()));
        }
        return insertMap;
    }
}

