/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.condition.Condition;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.collect.ImmutableList;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.CassandraFetcher;
import io.stargate.graphql.schema.fetchers.dml.DataTypeMapping;
import io.stargate.graphql.schema.fetchers.dml.FilterOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class DmlFetcher<ResultT>
extends CassandraFetcher<ResultT> {
    protected final Table table;
    protected final NameMapping nameMapping;
    protected final CqlIdentifier keyspaceId;
    protected final CqlIdentifier tableId;

    protected DmlFetcher(Table table, NameMapping nameMapping, Persistence persistence, AuthenticationService authenticationService) {
        super(persistence, authenticationService);
        this.table = table;
        this.nameMapping = nameMapping;
        this.keyspaceId = CqlIdentifier.fromInternal((String)table.keyspace());
        this.tableId = CqlIdentifier.fromInternal((String)this.table.name());
    }

    protected List<Condition> buildIfConditions(Table table, Map<String, Map<String, Object>> columnList) {
        if (columnList == null) {
            return ImmutableList.of();
        }
        ArrayList<Condition> clause = new ArrayList<Condition>();
        for (Map.Entry<String, Map<String, Object>> clauseEntry : columnList.entrySet()) {
            Column column = this.getColumn(table, clauseEntry.getKey());
            CqlIdentifier columnId = CqlIdentifier.fromInternal((String)column.name());
            for (Map.Entry<String, Object> conditionMap : clauseEntry.getValue().entrySet()) {
                FilterOperator operator = FilterOperator.fromFieldName(conditionMap.getKey());
                clause.add(operator.buildCondition(column, conditionMap.getValue(), this.nameMapping));
            }
        }
        return clause;
    }

    protected List<Relation> buildFilterConditions(Table table, Map<String, Map<String, Object>> columnList) {
        if (columnList == null) {
            return ImmutableList.of();
        }
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (Map.Entry<String, Map<String, Object>> clauseEntry : columnList.entrySet()) {
            Column column = this.getColumn(table, clauseEntry.getKey());
            for (Map.Entry<String, Object> condition : clauseEntry.getValue().entrySet()) {
                FilterOperator operator = FilterOperator.fromFieldName(condition.getKey());
                relations.add(operator.buildRelation(column, condition.getValue(), this.nameMapping));
            }
        }
        return relations;
    }

    protected List<Relation> buildClause(Table table, DataFetchingEnvironment environment) {
        if (environment.containsArgument("filter")) {
            Map columnList = (Map)environment.getArgument("filter");
            return this.buildFilterConditions(table, columnList);
        }
        Map value = (Map)environment.getArgument("value");
        ArrayList<Relation> relations = new ArrayList<Relation>();
        if (value == null) {
            return ImmutableList.of();
        }
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.getColumn(table, (String)entry.getKey());
            relations.add((Relation)Relation.column((CqlIdentifier)CqlIdentifier.fromInternal((String)column.name())).isEqualTo(this.toCqlTerm(column, entry.getValue())));
        }
        return relations;
    }

    protected CqlIdentifier getDBColumnName(Table table, String fieldName) {
        Column column = this.getColumn(table, fieldName);
        if (column == null) {
            return null;
        }
        return CqlIdentifier.fromInternal((String)column.name());
    }

    protected Column getColumn(Table table, String fieldName) {
        String columnName = this.nameMapping.getCqlName(table, fieldName);
        return table.column(columnName);
    }

    protected Term toCqlTerm(Column column, Object value) {
        return DataTypeMapping.toCqlTerm(column.type(), value, this.nameMapping);
    }
}

