/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.ddl;

import com.google.common.collect.ImmutableMap;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.SelectedField;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

class KeyspaceFormatter {
    KeyspaceFormatter() {
    }

    static List<Map<String, Object>> formatResult(Set<Keyspace> keyspaces, DataFetchingEnvironment environment) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Keyspace keyspace : keyspaces) {
            list.add(KeyspaceFormatter.formatResult(keyspace, environment));
        }
        return list;
    }

    static Map<String, Object> formatResult(Keyspace keyspace, DataFetchingEnvironment environment) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"name", (Object)keyspace.name());
        KeyspaceFormatter.formatChildren((ImmutableMap.Builder<String, Object>)builder, "table", () -> ((Keyspace)keyspace).tables(), arg_0 -> ((Keyspace)keyspace).table(arg_0), KeyspaceFormatter::buildTable, environment);
        KeyspaceFormatter.formatChildren((ImmutableMap.Builder<String, Object>)builder, "type", () -> ((Keyspace)keyspace).userDefinedTypes(), arg_0 -> ((Keyspace)keyspace).userDefinedType(arg_0), KeyspaceFormatter::buildUdt, environment);
        builder.put((Object)"dcs", KeyspaceFormatter.buildDcs(keyspace));
        return builder.build();
    }

    private static <ChildT> void formatChildren(ImmutableMap.Builder<String, Object> builder, String childFieldName, Supplier<Iterable<ChildT>> allChildrenGetter, Function<String, ChildT> childByNameGetter, Function<ChildT, Map<String, Object>> converter, DataFetchingEnvironment environment) {
        String name;
        SelectedField childField;
        ChildT child2;
        String allChildrenName = childFieldName + "s";
        if (environment.getSelectionSet().getField(allChildrenName) != null) {
            ArrayList<Map<String, Object>> formattedChildren = new ArrayList<Map<String, Object>>();
            for (ChildT child2 : allChildrenGetter.get()) {
                formattedChildren.add(converter.apply(child2));
            }
            builder.put((Object)allChildrenName, formattedChildren);
        }
        if ((childField = environment.getSelectionSet().getField(childFieldName)) != null && (child2 = childByNameGetter.apply(name = (String)childField.getArguments().get("name"))) != null) {
            builder.put((Object)childFieldName, converter.apply(child2));
        }
    }

    private static List<Map<String, String>> buildDcs(Keyspace keyspace) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Map.Entry entries : keyspace.replication().entrySet()) {
            if (((String)entries.getKey()).equals("class") || ((String)entries.getKey()).equals("replication_factor")) continue;
            list.add((Map<String, String>)ImmutableMap.of((Object)"name", entries.getKey(), (Object)"replicas", entries.getValue()));
        }
        return list;
    }

    private static Map<String, Object> buildTable(Table table) {
        return ImmutableMap.of((Object)"name", (Object)table.name(), (Object)"columns", KeyspaceFormatter.buildColumns(table.columns(), true));
    }

    private static Map<String, Object> buildUdt(UserDefinedType type) {
        return ImmutableMap.of((Object)"name", (Object)type.name(), (Object)"fields", KeyspaceFormatter.buildColumns(type.columns(), false));
    }

    private static List<Map<String, Object>> buildColumns(List<Column> columns, boolean includeKind) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Column column : columns) {
            list.add(KeyspaceFormatter.buildColumn(column, includeKind));
        }
        return list;
    }

    private static Map<String, Object> buildColumn(Column column, boolean includeKind) {
        return includeKind ? ImmutableMap.of((Object)"kind", (Object)KeyspaceFormatter.buildColumnKind(column), (Object)"name", (Object)column.name(), (Object)"type", KeyspaceFormatter.buildDataType(column.type())) : ImmutableMap.of((Object)"name", (Object)column.name(), (Object)"type", KeyspaceFormatter.buildDataType(column.type()));
    }

    private static Map<String, Object> buildDataType(Column.ColumnType columnType) {
        if (columnType.isUserDefined()) {
            return ImmutableMap.of((Object)"basic", (Object)KeyspaceFormatter.buildBasicType(columnType), (Object)"info", (Object)ImmutableMap.of((Object)"name", (Object)columnType.name(), (Object)"frozen", (Object)columnType.isFrozen()));
        }
        if (columnType.isCollection() || columnType.isTuple()) {
            return ImmutableMap.of((Object)"basic", (Object)KeyspaceFormatter.buildBasicType(columnType), (Object)"info", KeyspaceFormatter.buildParameterizedDataTypeInfo(columnType));
        }
        return ImmutableMap.of((Object)"basic", (Object)KeyspaceFormatter.buildBasicType(columnType));
    }

    private static Map<String, Object> buildParameterizedDataTypeInfo(Column.ColumnType columnType) {
        assert (columnType.isParameterized());
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Column.ColumnType type : columnType.parameters()) {
            list.add(KeyspaceFormatter.buildDataType(type));
        }
        return ImmutableMap.of((Object)"subTypes", list, (Object)"frozen", (Object)columnType.isFrozen());
    }

    private static String buildBasicType(Column.ColumnType columnType) {
        return columnType.rawType().name().toUpperCase();
    }

    private static String buildColumnKind(Column column) {
        switch (column.kind()) {
            case PartitionKey: {
                return "PARTITION";
            }
            case Clustering: {
                return "CLUSTERING";
            }
            case Regular: {
                return "REGULAR";
            }
            case Static: {
                return "STATIC";
            }
        }
        return "UNKNOWN";
    }
}

