/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.ddl;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspace;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspaceStart;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.graphql.schema.fetchers.ddl.DdlQueryFetcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateKeyspaceFetcher
extends DdlQueryFetcher {
    public CreateKeyspaceFetcher(Persistence persistence, AuthenticationService authenticationService) {
        super(persistence, authenticationService);
    }

    @Override
    public String getQuery(DataFetchingEnvironment dataFetchingEnvironment) {
        CreateKeyspaceStart start = SchemaBuilder.createKeyspace((CqlIdentifier)CqlIdentifier.fromInternal((String)((String)dataFetchingEnvironment.getArgument("name"))));
        boolean ifNotExists = (Boolean)dataFetchingEnvironment.getArgumentOrDefault("ifNotExists", (Object)Boolean.FALSE);
        if (ifNotExists) {
            start = start.ifNotExists();
        }
        Integer replicas = (Integer)dataFetchingEnvironment.getArgument("replicas");
        List datacenters = (List)dataFetchingEnvironment.getArgument("datacenters");
        if (replicas == null && datacenters == null) {
            throw new IllegalArgumentException("You must specify either replicas or datacenters");
        }
        if (replicas != null && datacenters != null) {
            throw new IllegalArgumentException("You can't specify both replicas and datacenters");
        }
        if (replicas != null) {
            return ((CreateKeyspace)start.withSimpleStrategy(replicas.intValue())).asCql();
        }
        return ((CreateKeyspace)start.withNetworkTopologyStrategy(this.parseDatacenters(datacenters))).asCql();
    }

    private Map<String, Integer> parseDatacenters(List<Map<String, Object>> datacenters) {
        assert (datacenters != null);
        if (datacenters.isEmpty()) {
            throw new IllegalArgumentException("datacenters must contain at least one element");
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map<String, Object> datacenter : datacenters) {
            String dcName = (String)datacenter.get("name");
            Integer dcReplicas = (Integer)datacenter.getOrDefault("replicas", 3);
            result.put(dcName, dcReplicas);
        }
        return result;
    }
}

