/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.types;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;

public class GqlMapBuilder {
    private final GraphQLType keyType;
    private final GraphQLType valueType;
    private final boolean isInput;

    public GqlMapBuilder(GraphQLType keyType, GraphQLType valueType, boolean isInput) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.isInput = isInput;
    }

    public GraphQLType build() {
        return new GraphQLList(this.buildKeyValueType());
    }

    private GraphQLType buildKeyValueType() {
        String keyTypeName = GqlMapBuilder.getTypeName(this.keyType);
        String valueTypeName = GqlMapBuilder.getTypeName(this.valueType);
        String name = String.format("Entry%sKey%sValue%s", keyTypeName, valueTypeName, this.isInput ? "Input" : "");
        return this.isInput ? this.buildInputType(name) : this.buildOutputType(name);
    }

    private GraphQLInputType buildInputType(String name) {
        return GraphQLInputObjectType.newInputObject().name(name).description("Represents a key/value type for a Map").field(GraphQLInputObjectField.newInputObjectField().name("key").type((GraphQLInputType)new GraphQLNonNull(this.keyType)).build()).field(GraphQLInputObjectField.newInputObjectField().name("value").type((GraphQLInputType)this.valueType).build()).build();
    }

    private GraphQLOutputType buildOutputType(String name) {
        return GraphQLObjectType.newObject().description("Represents a key/value type for a Map").name(name).field(GraphQLFieldDefinition.newFieldDefinition().name("key").type((GraphQLOutputType)new GraphQLNonNull(this.keyType)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("value").type((GraphQLOutputType)this.valueType).build()).build();
    }

    private static String getTypeName(GraphQLType type) {
        if (type instanceof GraphQLNamedType) {
            return ((GraphQLNamedType)type).getName();
        }
        String modifier = "";
        if (type instanceof GraphQLList) {
            modifier = "List";
        }
        if (!(type instanceof GraphQLModifiedType)) {
            throw new RuntimeException(String.format("GraphQL type %s not supported in maps", type));
        }
        return modifier + GqlMapBuilder.getTypeName(((GraphQLModifiedType)type).getWrappedType());
    }
}

