/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.datastax.oss.driver.api.querybuilder.condition.Condition;
import com.datastax.oss.driver.api.querybuilder.relation.ColumnRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.collect.ImmutableList;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.CassandraFetcher;
import io.stargate.graphql.schema.fetchers.dml.DataTypeMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class DmlFetcher<ResultT>
extends CassandraFetcher<ResultT> {
    protected final Table table;
    protected final NameMapping nameMapping;

    protected DmlFetcher(Table table, NameMapping nameMapping, Persistence persistence, AuthenticationService authenticationService) {
        super(persistence, authenticationService);
        this.table = table;
        this.nameMapping = nameMapping;
    }

    protected List<Condition> buildIfConditions(Table table, Map<String, Map<String, Object>> columnList) {
        if (columnList == null) {
            return ImmutableList.of();
        }
        ArrayList<Condition> clause = new ArrayList<Condition>();
        for (Map.Entry<String, Map<String, Object>> clauseEntry : columnList.entrySet()) {
            Column column = this.getColumn(table, clauseEntry.getKey());
            for (Map.Entry<String, Object> condition : clauseEntry.getValue().entrySet()) {
                if (condition.getKey().equals("in")) {
                    clause.add((Condition)Condition.column((String)column.name()).in(this.buildListLiterals(column, condition.getValue())));
                    continue;
                }
                Term dbValue = this.toCqlTerm(column, condition.getValue());
                switch (condition.getKey()) {
                    case "eq": {
                        clause.add((Condition)Condition.column((String)column.name()).isEqualTo(dbValue));
                        break;
                    }
                    case "notEq": {
                        clause.add((Condition)Condition.column((String)column.name()).isNotEqualTo(dbValue));
                        break;
                    }
                    case "gt": {
                        clause.add((Condition)Condition.column((String)column.name()).isGreaterThan(dbValue));
                        break;
                    }
                    case "gte": {
                        clause.add((Condition)Condition.column((String)column.name()).isGreaterThanOrEqualTo(dbValue));
                        break;
                    }
                    case "lt": {
                        clause.add((Condition)Condition.column((String)column.name()).isLessThan(dbValue));
                        break;
                    }
                    case "lte": {
                        clause.add((Condition)Condition.column((String)column.name()).isLessThanOrEqualTo(dbValue));
                        break;
                    }
                }
            }
        }
        return clause;
    }

    private List<Term> buildListLiterals(Column column, Object o) {
        if (o instanceof Collection) {
            Collection values = (Collection)o;
            return values.stream().map(item -> this.toCqlTerm(column, item)).collect(Collectors.toList());
        }
        return Collections.singletonList(this.toCqlTerm(column, o));
    }

    protected List<Relation> buildFilterConditions(Table table, Map<String, Map<String, Object>> columnList) {
        if (columnList == null) {
            return ImmutableList.of();
        }
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (Map.Entry<String, Map<String, Object>> clauseEntry : columnList.entrySet()) {
            Column column = this.getColumn(table, clauseEntry.getKey());
            for (Map.Entry<String, Object> condition : clauseEntry.getValue().entrySet()) {
                Relation relation;
                ColumnRelationBuilder relationStart = Relation.column((String)column.name());
                if (condition.getKey().equals("in")) {
                    relation = (Relation)relationStart.in(this.buildListLiterals(column, condition.getValue()));
                } else if (condition.getKey().equals("contains")) {
                    relation = (Relation)relationStart.contains(this.toCqlElementTerm(column, condition.getValue()));
                } else if (condition.getKey().equals("containsKey")) {
                    relation = (Relation)relationStart.containsKey(this.toCqlKeyTerm(column, condition.getValue()));
                } else if (condition.getKey().equals("containsEntry")) {
                    Column.ColumnType mapType = column.type();
                    assert (mapType != null && mapType.isMap());
                    Map entry = (Map)condition.getValue();
                    Column.ColumnType keyType = (Column.ColumnType)mapType.parameters().get(0);
                    Term keyTerm = this.toCqlTerm(keyType, entry.get("key"));
                    Column.ColumnType valueType = (Column.ColumnType)mapType.parameters().get(1);
                    Term valueTerm = this.toCqlTerm(valueType, entry.get("value"));
                    relation = (Relation)Relation.mapValue((String)column.name(), (Term)keyTerm).isEqualTo(valueTerm);
                } else {
                    Term rightTerm = this.toCqlTerm(column, condition.getValue());
                    switch (condition.getKey()) {
                        case "eq": {
                            relation = (Relation)relationStart.isEqualTo(rightTerm);
                            break;
                        }
                        case "notEq": {
                            relation = (Relation)relationStart.isNotEqualTo(rightTerm);
                            break;
                        }
                        case "gt": {
                            relation = (Relation)relationStart.isGreaterThan(rightTerm);
                            break;
                        }
                        case "gte": {
                            relation = (Relation)relationStart.isGreaterThanOrEqualTo(rightTerm);
                            break;
                        }
                        case "lt": {
                            relation = (Relation)relationStart.isLessThan(rightTerm);
                            break;
                        }
                        case "lte": {
                            relation = (Relation)relationStart.isLessThanOrEqualTo(rightTerm);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported relation type " + condition.getKey());
                        }
                    }
                }
                relations.add(relation);
            }
        }
        return relations;
    }

    protected List<Relation> buildClause(Table table, DataFetchingEnvironment environment) {
        if (environment.containsArgument("filter")) {
            Map columnList = (Map)environment.getArgument("filter");
            return this.buildFilterConditions(table, columnList);
        }
        Map value = (Map)environment.getArgument("value");
        ArrayList<Relation> relations = new ArrayList<Relation>();
        if (value == null) {
            return ImmutableList.of();
        }
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.getColumn(table, (String)entry.getKey());
            relations.add((Relation)Relation.column((String)column.name()).isEqualTo(this.toCqlTerm(column, entry.getValue())));
        }
        return relations;
    }

    protected String getDBColumnName(Table table, String fieldName) {
        Column column = this.getColumn(table, fieldName);
        if (column == null) {
            return null;
        }
        return column.name();
    }

    protected Column getColumn(Table table, String fieldName) {
        return (Column)this.nameMapping.getColumnNames(table).inverse().get((Object)fieldName);
    }

    protected Term toCqlTerm(Column column, Object value) {
        return this.toCqlTerm(column.type(), value);
    }

    private Term toCqlElementTerm(Column column, Object value) {
        Column.ColumnType collectionType = column.type();
        assert (collectionType != null && collectionType.isCollection());
        Column.ColumnType elementType = (Column.ColumnType)collectionType.parameters().get(collectionType.isMap() ? 1 : 0);
        return this.toCqlTerm(elementType, value);
    }

    private Term toCqlKeyTerm(Column column, Object value) {
        Column.ColumnType mapType = column.type();
        assert (mapType != null && mapType.isMap());
        Column.ColumnType keyType = (Column.ColumnType)mapType.parameters().get(0);
        return this.toCqlTerm(keyType, value);
    }

    private Term toCqlTerm(Column.ColumnType type, Object value) {
        return DataTypeMapping.toCqlTerm(type, value, this.nameMapping);
    }
}

