/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.ddl;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.graphql.schema.fetchers.CassandraFetcher;
import java.util.List;
import java.util.Map;

public abstract class DdlQueryFetcher
extends CassandraFetcher<Boolean> {
    protected DdlQueryFetcher(Persistence persistence, AuthenticationService authenticationService) {
        super(persistence, authenticationService);
    }

    @Override
    protected Boolean get(DataFetchingEnvironment environment, DataStore dataStore) throws Exception {
        dataStore.query(this.getQuery(environment), new Object[0]).get();
        return true;
    }

    abstract String getQuery(DataFetchingEnvironment var1);

    protected DataType decodeType(Object typeObject) {
        Map type = (Map)typeObject;
        String basic = (String)type.get("basic");
        Map info = (Map)type.get("info");
        switch (basic) {
            case "INT": 
            case "INET": {
                return DataTypes.INT;
            }
            case "TIMEUUID": {
                return DataTypes.TIMEUUID;
            }
            case "TIMESTAMP": {
                return DataTypes.TIMESTAMP;
            }
            case "BIGINT": {
                return DataTypes.BIGINT;
            }
            case "TIME": {
                return DataTypes.TIME;
            }
            case "DURATION": {
                return DataTypes.DURATION;
            }
            case "VARINT": {
                return DataTypes.VARINT;
            }
            case "UUID": {
                return DataTypes.UUID;
            }
            case "BOOLEAN": {
                return DataTypes.BOOLEAN;
            }
            case "TINYINT": {
                return DataTypes.TINYINT;
            }
            case "SMALLINT": {
                return DataTypes.SMALLINT;
            }
            case "ASCII": {
                return DataTypes.ASCII;
            }
            case "DECIMAL": {
                return DataTypes.DECIMAL;
            }
            case "BLOB": {
                return DataTypes.BLOB;
            }
            case "VARCHAR": 
            case "TEXT": {
                return DataTypes.TEXT;
            }
            case "DOUBLE": {
                return DataTypes.DOUBLE;
            }
            case "COUNTER": {
                return DataTypes.COUNTER;
            }
            case "DATE": {
                return DataTypes.DATE;
            }
            case "FLOAT": {
                return DataTypes.FLOAT;
            }
            case "LIST": {
                List subTypes = (List)info.get("subTypes");
                if (subTypes == null || subTypes.size() != 1) {
                    throw new IllegalArgumentException("List sub types should contain 1 item");
                }
                return DataTypes.listOf((DataType)this.decodeType(subTypes.get(0)));
            }
            case "SET": {
                List subTypes = (List)info.get("subTypes");
                if (subTypes == null || subTypes.size() != 1) {
                    throw new IllegalArgumentException("Set sub types should contain 1 item");
                }
                subTypes = (List)info.get("subTypes");
                return DataTypes.setOf((DataType)this.decodeType(subTypes.get(0)));
            }
            case "MAP": {
                List subTypes = (List)info.get("subTypes");
                if (subTypes == null || subTypes.size() != 2) {
                    throw new IllegalArgumentException("Map sub types should contain 2 items");
                }
                return DataTypes.mapOf((DataType)this.decodeType(subTypes.get(0)), (DataType)this.decodeType(subTypes.get(1)));
            }
        }
        throw new RuntimeException(String.format("Data type %s is not supported", basic));
    }
}

