/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.StoredCredentials;
import io.stargate.db.ImmutableParameters;
import io.stargate.db.Parameters;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.graphql.graphqlservlet.HTTPAwareContextImpl;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import org.apache.cassandra.stargate.db.ConsistencyLevel;

public abstract class CassandraFetcher<ResultT>
implements DataFetcher<ResultT> {
    protected final Persistence persistence;
    protected final AuthenticationService authenticationService;

    public CassandraFetcher(Persistence persistence, AuthenticationService authenticationService) {
        this.persistence = persistence;
        this.authenticationService = authenticationService;
    }

    public final ResultT get(DataFetchingEnvironment environment) throws Exception {
        Parameters parameters;
        HTTPAwareContextImpl httpAwareContext = (HTTPAwareContextImpl)environment.getContext();
        String token = httpAwareContext.getAuthToken();
        StoredCredentials storedCredentials = this.authenticationService.validateToken(token);
        Map options = (Map)environment.getArgument("options");
        if (options != null) {
            Object pageState;
            Object pageSize;
            Object serialConsistency;
            ImmutableParameters.Builder builder = Parameters.builder();
            Object consistency = options.get("consistency");
            if (consistency != null) {
                builder.consistencyLevel(ConsistencyLevel.valueOf((String)((String)consistency)));
            }
            if ((serialConsistency = options.get("serialConsistency")) != null) {
                builder.serialConsistencyLevel(ConsistencyLevel.valueOf((String)((String)serialConsistency)));
            }
            if ((pageSize = options.get("pageSize")) != null) {
                builder.pageSize(((Integer)pageSize).intValue());
            }
            if ((pageState = options.get("pageState")) != null) {
                builder.pagingState(ByteBuffer.wrap(Base64.getDecoder().decode((String)pageState)));
            }
            parameters = builder.build();
        } else {
            parameters = Parameters.defaults();
        }
        DataStore dataStore = DataStore.create((Persistence)this.persistence, (String)storedCredentials.getRoleName(), (Parameters)parameters);
        return this.get(environment, dataStore);
    }

    protected abstract ResultT get(DataFetchingEnvironment var1, DataStore var2) throws Exception;
}

