/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.util.CaseUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NameMapping {
    private final BiMap<Table, String> entityNames = HashBiMap.create();
    private final Map<Table, BiMap<Column, String>> columnNames;
    private final BiMap<UserDefinedType, String> udtNames = HashBiMap.create();
    private final Map<UserDefinedType, BiMap<Column, String>> fieldNames;

    public NameMapping(Set<Table> tables, List<UserDefinedType> udts) {
        this.columnNames = new HashMap<Table, BiMap<Column, String>>();
        this.buildNames(tables);
        this.fieldNames = new HashMap<UserDefinedType, BiMap<Column, String>>();
        this.buildNames(udts);
    }

    private void buildNames(Set<Table> tables) {
        for (Table table : tables) {
            this.entityNames.put((Object)table, (Object)CaseUtil.toCamel(table.name()));
            this.columnNames.put(table, this.buildColumnNames(table.columns()));
        }
    }

    private void buildNames(List<UserDefinedType> udts) {
        for (UserDefinedType udt : udts) {
            this.udtNames.put((Object)udt, (Object)(CaseUtil.toCamel(udt.name()) + "Udt"));
            this.fieldNames.put(udt, this.buildColumnNames(udt.columns()));
        }
    }

    private BiMap<Column, String> buildColumnNames(List<Column> columns) {
        HashBiMap map = HashBiMap.create();
        for (Column column : columns) {
            map.put((Object)column, (Object)CaseUtil.toLowerCamel(column.name()));
        }
        return map;
    }

    public BiMap<Table, String> getEntityNames() {
        return this.entityNames;
    }

    public BiMap<Column, String> getColumnNames(Table table) {
        return this.columnNames.get(table);
    }

    public BiMap<UserDefinedType, String> getUdtNames() {
        return this.udtNames;
    }

    public BiMap<Column, String> getFieldNames(UserDefinedType udt) {
        return this.fieldNames.get(udt);
    }
}

