/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema;

import graphql.Scalars;
import graphql.schema.GraphQLScalarType;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableListType;
import io.stargate.graphql.schema.CustomScalar;
import io.stargate.graphql.schema.NameMapping;
import java.util.HashMap;
import java.util.Map;

abstract class FieldTypeCache<GraphqlT> {
    protected final NameMapping nameMapping;
    private final Map<Column.ColumnType, GraphqlT> types = new HashMap<Column.ColumnType, GraphqlT>();

    FieldTypeCache(NameMapping nameMapping) {
        this.nameMapping = nameMapping;
    }

    GraphqlT get(Column.ColumnType type) {
        type = this.normalize(type);
        return (GraphqlT)this.types.computeIfAbsent(type, this::compute);
    }

    private Column.ColumnType normalize(Column.ColumnType type) {
        if ((type = type.frozen(false)).isSet()) {
            type = ImmutableListType.builder().addAllParameters((Iterable)type.parameters()).build();
        }
        return type;
    }

    protected abstract GraphqlT compute(Column.ColumnType var1);

    protected GraphQLScalarType getScalar(Column.Type type) {
        switch (type) {
            case Ascii: {
                return CustomScalar.ASCII.getGraphQLScalar();
            }
            case Bigint: {
                return CustomScalar.BIGINT.getGraphQLScalar();
            }
            case Blob: {
                return CustomScalar.BLOB.getGraphQLScalar();
            }
            case Boolean: {
                return Scalars.GraphQLBoolean;
            }
            case Counter: {
                return CustomScalar.COUNTER.getGraphQLScalar();
            }
            case Decimal: {
                return CustomScalar.DECIMAL.getGraphQLScalar();
            }
            case Double: {
                return Scalars.GraphQLFloat;
            }
            case Float: {
                return CustomScalar.FLOAT.getGraphQLScalar();
            }
            case Int: 
            case Tinyint: 
            case Smallint: {
                return Scalars.GraphQLInt;
            }
            case Text: 
            case Varchar: {
                return Scalars.GraphQLString;
            }
            case Timestamp: {
                return CustomScalar.TIMESTAMP.getGraphQLScalar();
            }
            case Uuid: {
                return CustomScalar.UUID.getGraphQLScalar();
            }
            case Varint: {
                return CustomScalar.VARINT.getGraphQLScalar();
            }
            case Timeuuid: {
                return CustomScalar.TIMEUUID.getGraphQLScalar();
            }
            case Inet: {
                return CustomScalar.INET.getGraphQLScalar();
            }
            case Date: {
                return CustomScalar.DATE.getGraphQLScalar();
            }
            case Time: {
                return CustomScalar.TIME.getGraphQLScalar();
            }
        }
        throw new IllegalArgumentException("Unsupported primitive type " + type);
    }
}

