/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.FieldTypeCache;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.types.GqlMapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FieldOutputTypeCache
extends FieldTypeCache<GraphQLOutputType> {
    private static final Logger LOG = LoggerFactory.getLogger(FieldOutputTypeCache.class);

    FieldOutputTypeCache(NameMapping nameMapping) {
        super(nameMapping);
    }

    @Override
    protected GraphQLOutputType compute(Column.ColumnType columnType) {
        if (columnType.isMap()) {
            GraphQLType keyType = (GraphQLType)this.get((Column.ColumnType)columnType.parameters().get(0));
            GraphQLType valueType = (GraphQLType)this.get((Column.ColumnType)columnType.parameters().get(1));
            return (GraphQLOutputType)new GqlMapBuilder(keyType, valueType, false).build();
        }
        if (columnType.isList() || columnType.isSet()) {
            return new GraphQLList((GraphQLType)this.get((Column.ColumnType)columnType.parameters().get(0)));
        }
        if (columnType.isUserDefined()) {
            UserDefinedType udt = (UserDefinedType)columnType;
            return this.computeUdt(udt);
        }
        if (columnType.isTuple()) {
            throw new UnsupportedOperationException("Tuples are not implemented yet");
        }
        return this.getScalar(columnType.rawType());
    }

    private GraphQLOutputType computeUdt(UserDefinedType udt) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name((String)this.nameMapping.getUdtNames().get((Object)udt));
        for (Column column : udt.columns()) {
            try {
                builder.field(new GraphQLFieldDefinition.Builder().name((String)this.nameMapping.getFieldNames(udt).get((Object)column)).type((GraphQLOutputType)this.get(column.type())).build());
            }
            catch (Exception e) {
                LOG.error(String.format("Type for %s could not be created", column.name()), (Throwable)e);
            }
        }
        return builder.build();
    }
}

