/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema;

import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLType;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.FieldTypeCache;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.types.GqlMapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FieldInputTypeCache
extends FieldTypeCache<GraphQLInputType> {
    private static final Logger LOG = LoggerFactory.getLogger(FieldInputTypeCache.class);

    FieldInputTypeCache(NameMapping nameMapping) {
        super(nameMapping);
    }

    @Override
    protected GraphQLInputType compute(Column.ColumnType columnType) {
        if (columnType.isMap()) {
            GraphQLType keyType = (GraphQLType)this.get((Column.ColumnType)columnType.parameters().get(0));
            GraphQLType valueType = (GraphQLType)this.get((Column.ColumnType)columnType.parameters().get(1));
            return (GraphQLInputType)new GqlMapBuilder(keyType, valueType, true).build();
        }
        if (columnType.isList() || columnType.isSet()) {
            return new GraphQLList((GraphQLType)this.get((Column.ColumnType)columnType.parameters().get(0)));
        }
        if (columnType.isUserDefined()) {
            UserDefinedType udt = (UserDefinedType)columnType;
            return this.computeUdt(udt);
        }
        if (columnType.isTuple()) {
            throw new UnsupportedOperationException("Tuples are not implemented yet");
        }
        return this.getScalar(columnType.rawType());
    }

    private GraphQLInputType computeUdt(UserDefinedType udt) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject().name((String)this.nameMapping.getUdtNames().get((Object)udt) + "Input");
        for (Column column : udt.columns()) {
            try {
                builder.field(GraphQLInputObjectField.newInputObjectField().name((String)this.nameMapping.getFieldNames(udt).get((Object)column)).type((GraphQLInputType)this.get(column.type())).build());
            }
            catch (Exception e) {
                LOG.error(String.format("Input type for %s could not be created", column.name()), (Throwable)e);
            }
        }
        return builder.build();
    }
}

