/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import graphql.Scalars;
import graphql.introspection.Introspection;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.FieldFilterInputTypeCache;
import io.stargate.graphql.schema.FieldInputTypeCache;
import io.stargate.graphql.schema.FieldOutputTypeCache;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.DeleteMutationFetcher;
import io.stargate.graphql.schema.fetchers.dml.InsertMutationFetcher;
import io.stargate.graphql.schema.fetchers.dml.QueryFetcher;
import io.stargate.graphql.schema.fetchers.dml.UpdateMutationFetcher;
import io.stargate.graphql.util.CaseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DmlSchemaBuilder {
    private static final Logger log = LoggerFactory.getLogger(DmlSchemaBuilder.class);
    private final Persistence persistence;
    private final AuthenticationService authenticationService;
    private final Map<Table, GraphQLOutputType> entityResultMap = new HashMap<Table, GraphQLOutputType>();
    private final FieldInputTypeCache fieldInputTypes;
    private final FieldOutputTypeCache fieldOutputTypes;
    private final FieldFilterInputTypeCache fieldFilterInputTypes;
    private final NameMapping nameMapping;
    private final Keyspace keyspace;
    private static final GraphQLInputType MUTATION_OPTIONS = GraphQLInputObjectType.newInputObject().name("MutationOptions").field(GraphQLInputObjectField.newInputObjectField().name("consistency").type((GraphQLInputType)GraphQLEnumType.newEnum().name("MutationConsistency").value("LOCAL_ONE").value("LOCAL_QUORUM").value("ALL").build()).build()).field(GraphQLInputObjectField.newInputObjectField().name("serialConsistency").type((GraphQLInputType)GraphQLEnumType.newEnum().name("SerialConsistency").value("SERIAL").value("LOCAL_SERIAL").build()).build()).field(GraphQLInputObjectField.newInputObjectField().name("ttl").type((GraphQLInputType)Scalars.GraphQLInt).build()).build();

    DmlSchemaBuilder(Persistence persistence, AuthenticationService authenticationService, Keyspace keyspace) {
        this.persistence = persistence;
        this.authenticationService = authenticationService;
        this.keyspace = keyspace;
        this.nameMapping = new NameMapping(keyspace.tables(), keyspace.userDefinedTypes());
        this.fieldInputTypes = new FieldInputTypeCache(this.nameMapping);
        this.fieldOutputTypes = new FieldOutputTypeCache(this.nameMapping);
        this.fieldFilterInputTypes = new FieldFilterInputTypeCache(this.fieldInputTypes, this.nameMapping);
    }

    GraphQLSchema build() {
        GraphQLSchema.Builder builder = new GraphQLSchema.Builder();
        ArrayList<GraphQLFieldDefinition> queryFields = new ArrayList<GraphQLFieldDefinition>();
        ArrayList<GraphQLFieldDefinition> mutationFields = new ArrayList<GraphQLFieldDefinition>();
        for (Table table : this.keyspace.tables()) {
            List<GraphQLFieldDefinition> tableMutationFields;
            List<GraphQLFieldDefinition> tableQueryField;
            Set<GraphQLType> additionalTypes;
            try {
                additionalTypes = this.buildTypesForTable(table);
                tableQueryField = this.buildQuery(table);
                tableMutationFields = this.buildMutations(table);
            }
            catch (Exception e) {
                log.warn("Skipping table " + table.name());
                continue;
            }
            builder.additionalTypes(additionalTypes);
            queryFields.addAll(tableQueryField);
            mutationFields.addAll(tableMutationFields);
        }
        builder.additionalDirective(GraphQLDirective.newDirective().validLocation(Introspection.DirectiveLocation.MUTATION).name("atomic").description("Instructs the server to apply the mutations in a LOGGED batch").build());
        if (queryFields.isEmpty()) {
            GraphQLFieldDefinition emptyQueryField = GraphQLFieldDefinition.newFieldDefinition().name("__keyspaceEmptyQuery").description("Placeholder query that is exposed when a keyspace is empty.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(d -> true).build();
            queryFields.add(emptyQueryField);
        }
        if (mutationFields.isEmpty()) {
            GraphQLFieldDefinition emptyMutationField = GraphQLFieldDefinition.newFieldDefinition().name("__keyspaceEmptyMutation").description("Placeholder mutation that is exposed when a keyspace is empty.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(d -> true).build();
            mutationFields.add(emptyMutationField);
        }
        builder.additionalType(this.buildQueryOptionsInputType());
        builder.query(this.buildQueries(queryFields));
        builder.mutation(this.buildMutationRoot(mutationFields));
        return builder.build();
    }

    private GraphQLObjectType buildMutationRoot(List<GraphQLFieldDefinition> mutationFields) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("Mutation");
        for (GraphQLFieldDefinition mutation : mutationFields) {
            builder.field(mutation);
        }
        return builder.build();
    }

    private GraphQLObjectType buildQueries(List<GraphQLFieldDefinition> queryFields) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("Query");
        for (GraphQLFieldDefinition fieldDefinition : queryFields) {
            builder.field(fieldDefinition);
        }
        return builder.build();
    }

    private List<GraphQLFieldDefinition> buildQuery(Table table) {
        GraphQLFieldDefinition query = GraphQLFieldDefinition.newFieldDefinition().name(CaseUtil.toLowerCamel(table.name())).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "Input"))).argument(GraphQLArgument.newArgument().name("filter").type((GraphQLInputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "FilterInput"))).argument(GraphQLArgument.newArgument().name("orderBy").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "Order")))).argument(GraphQLArgument.newArgument().name("options").type((GraphQLInputType)new GraphQLTypeReference("QueryOptions"))).type(this.buildEntityResultOutput(table)).dataFetcher((DataFetcher)new QueryFetcher(table, this.nameMapping, this.persistence, this.authenticationService)).build();
        GraphQLFieldDefinition filterQuery = GraphQLFieldDefinition.newFieldDefinition().name(CaseUtil.toLowerCamel(table.name()) + "Filter").deprecate("No longer supported. Use root type instead.").argument(GraphQLArgument.newArgument().name("filter").type((GraphQLInputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "FilterInput"))).argument(GraphQLArgument.newArgument().name("orderBy").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "Order")))).argument(GraphQLArgument.newArgument().name("options").type((GraphQLInputType)new GraphQLTypeReference("QueryOptions"))).type(this.buildEntityResultOutput(table)).dataFetcher((DataFetcher)new QueryFetcher(table, this.nameMapping, this.persistence, this.authenticationService)).build();
        return ImmutableList.of((Object)query, (Object)filterQuery);
    }

    private List<GraphQLFieldDefinition> buildMutations(Table table) {
        ArrayList<GraphQLFieldDefinition> mutationFields = new ArrayList<GraphQLFieldDefinition>();
        mutationFields.add(this.buildDelete(table));
        mutationFields.add(this.buildInsert(table));
        mutationFields.add(this.buildUpdate(table));
        return mutationFields;
    }

    private Set<GraphQLType> buildTypesForTable(Table table) {
        HashSet<GraphQLType> additionalTypes = new HashSet<GraphQLType>();
        additionalTypes.add((GraphQLType)this.buildType(table));
        additionalTypes.add(this.buildInputType(table));
        additionalTypes.add(this.buildOrderType(table));
        additionalTypes.add((GraphQLType)this.buildMutationResult(table));
        additionalTypes.add(this.buildFilterInput(table));
        return additionalTypes;
    }

    private GraphQLType buildFilterInput(Table table) {
        return GraphQLInputObjectType.newInputObject().name((String)this.nameMapping.getEntityNames().get((Object)table) + "FilterInput").fields(this.buildFilterInputFields(table)).build();
    }

    private GraphQLFieldDefinition buildUpdate(Table table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("update" + (String)this.nameMapping.getEntityNames().get((Object)table)).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "Input")))).argument(GraphQLArgument.newArgument().name("ifExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("ifCondition").type((GraphQLInputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "FilterInput"))).argument(GraphQLArgument.newArgument().name("options").type(MUTATION_OPTIONS)).type((GraphQLOutputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "MutationResult")).dataFetcher((DataFetcher)new UpdateMutationFetcher(table, this.nameMapping, this.persistence, this.authenticationService)).build();
    }

    private GraphQLFieldDefinition buildInsert(Table table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("insert" + (String)this.nameMapping.getEntityNames().get((Object)table)).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "Input")))).argument(GraphQLArgument.newArgument().name("ifNotExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("options").type(MUTATION_OPTIONS)).type((GraphQLOutputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "MutationResult")).dataFetcher((DataFetcher)new InsertMutationFetcher(table, this.nameMapping, this.persistence, this.authenticationService)).build();
    }

    private GraphQLFieldDefinition buildDelete(Table table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("delete" + (String)this.nameMapping.getEntityNames().get((Object)table)).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "Input")))).argument(GraphQLArgument.newArgument().name("ifExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("ifCondition").type((GraphQLInputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "FilterInput"))).argument(GraphQLArgument.newArgument().name("options").type(MUTATION_OPTIONS)).type((GraphQLOutputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "MutationResult")).dataFetcher((DataFetcher)new DeleteMutationFetcher(table, this.nameMapping, this.persistence, this.authenticationService)).build();
    }

    private List<GraphQLInputObjectField> buildFilterInputFields(Table table) {
        ArrayList<GraphQLInputObjectField> fields = new ArrayList<GraphQLInputObjectField>();
        for (Column column : table.columns()) {
            fields.add(GraphQLInputObjectField.newInputObjectField().name((String)this.nameMapping.getColumnNames(table).get((Object)column)).type((GraphQLInputType)this.fieldFilterInputTypes.get(column.type())).build());
        }
        Preconditions.checkState((!fields.isEmpty() ? 1 : 0) != 0, (Object)"Could not generate an input type for table, skipping.");
        return fields;
    }

    private GraphQLOutputType buildMutationResult(Table table) {
        return GraphQLObjectType.newObject().name((String)this.nameMapping.getEntityNames().get((Object)table) + "MutationResult").field(GraphQLFieldDefinition.newFieldDefinition().name("applied").type((GraphQLOutputType)Scalars.GraphQLBoolean)).field(GraphQLFieldDefinition.newFieldDefinition().name("value").type((GraphQLOutputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table)))).build();
    }

    private GraphQLType buildQueryOptionsInputType() {
        return GraphQLInputObjectType.newInputObject().name("QueryOptions").field(GraphQLInputObjectField.newInputObjectField().name("consistency").type((GraphQLInputType)GraphQLEnumType.newEnum().name("QueryConsistency").value("LOCAL_ONE").value("LOCAL_QUORUM").value("ALL").value("SERIAL").value("LOCAL_SERIAL").build()).build()).field(GraphQLInputObjectField.newInputObjectField().name("limit").type((GraphQLInputType)Scalars.GraphQLInt).build()).field(GraphQLInputObjectField.newInputObjectField().name("pageSize").type((GraphQLInputType)Scalars.GraphQLInt).defaultValue((Object)100).build()).field(GraphQLInputObjectField.newInputObjectField().name("pageState").type((GraphQLInputType)Scalars.GraphQLString).build()).build();
    }

    private GraphQLType buildOrderType(Table table) {
        GraphQLEnumType.Builder input = GraphQLEnumType.newEnum().name((String)this.nameMapping.getEntityNames().get((Object)table) + "Order");
        for (Column columnMetadata : table.columns()) {
            input.value((String)this.nameMapping.getColumnNames(table).get((Object)columnMetadata) + "_DESC");
            input.value((String)this.nameMapping.getColumnNames(table).get((Object)columnMetadata) + "_ASC");
        }
        return input.build();
    }

    private GraphQLType buildInputType(Table table) {
        GraphQLInputObjectType.Builder input = GraphQLInputObjectType.newInputObject().name((String)this.nameMapping.getEntityNames().get((Object)table) + "Input");
        for (Column columnMetadata : table.columns()) {
            try {
                GraphQLInputObjectField field = GraphQLInputObjectField.newInputObjectField().name((String)this.nameMapping.getColumnNames(table).get((Object)columnMetadata)).type((GraphQLInputType)this.fieldInputTypes.get(columnMetadata.type())).build();
                input.field(field);
            }
            catch (Exception e) {
                log.error(String.format("Input type for %s could not be created", columnMetadata.name()), (Throwable)e);
            }
        }
        return input.build();
    }

    private GraphQLOutputType buildEntityResultOutput(Table table) {
        if (this.entityResultMap.containsKey(table)) {
            return this.entityResultMap.get(table);
        }
        GraphQLObjectType entityResultType = GraphQLObjectType.newObject().name((String)this.nameMapping.getEntityNames().get((Object)table) + "Result").field(GraphQLFieldDefinition.newFieldDefinition().name("pageState").type((GraphQLOutputType)Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("values").type((GraphQLOutputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table)))))).build();
        this.entityResultMap.put(table, (GraphQLOutputType)entityResultType);
        return entityResultType;
    }

    public GraphQLObjectType buildType(Table table) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name((String)this.nameMapping.getEntityNames().get((Object)table));
        for (Column columnMetadata : table.columns()) {
            try {
                GraphQLFieldDefinition.Builder fieldBuilder = this.buildOutputField(table, columnMetadata);
                builder.field(fieldBuilder.build());
            }
            catch (Exception e) {
                log.error(String.format("Type for %s could not be created", columnMetadata.name()), (Throwable)e);
            }
        }
        return builder.build();
    }

    private GraphQLFieldDefinition.Builder buildOutputField(Table table, Column columnMetadata) {
        return new GraphQLFieldDefinition.Builder().name((String)this.nameMapping.getColumnNames(table).get((Object)columnMetadata)).type((GraphQLOutputType)this.fieldOutputTypes.get(columnMetadata.type()));
    }
}

