/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.graphqlservlet;

import graphql.kickstart.execution.context.GraphQLContext;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.DefaultClaims;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import org.dataloader.DataLoaderRegistry;

public class HTTPAwareContextImpl
implements GraphQLContext {
    private final DataLoaderRegistry dataLoaderRegistry;
    private Session session;
    private HandshakeRequest handshakeRequest;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private final BatchContext batchContext = new BatchContext();
    private static final String HEADER = "Authorization";
    private static final String PREFIX = "Bearer ";

    public HTTPAwareContextImpl(DataLoaderRegistry dataLoaderRegistry, HttpServletRequest request, HttpServletResponse response) {
        this.dataLoaderRegistry = dataLoaderRegistry;
        this.request = request;
        this.response = response;
    }

    public HTTPAwareContextImpl(DataLoaderRegistry dataLoaderRegistry, Session session, HandshakeRequest handshakeRequest) {
        this.dataLoaderRegistry = dataLoaderRegistry;
        this.session = session;
        this.handshakeRequest = handshakeRequest;
    }

    public String getAuthToken() {
        return this.request.getHeader("X-Cassandra-Token");
    }

    public String getUserOrRole() {
        if (this.hasJWTToken()) {
            String authHeader = this.request.getHeader(HEADER);
            String jwt = authHeader.substring(authHeader.indexOf(PREFIX) + PREFIX.length());
            Claims claims = HTTPAwareContextImpl.decodeJWT(jwt);
            if (claims != null) {
                return (String)claims.get("X-Cassandra-User", String.class);
            }
            return null;
        }
        return null;
    }

    public static Claims decodeJWT(String jwt) {
        try {
            DefaultClaims claims = (DefaultClaims)Jwts.parser().parse(jwt).getBody();
            return claims;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean hasJWTToken() {
        String header = this.request.getHeader(HEADER);
        return header != null && header.startsWith(PREFIX);
    }

    public Optional<Subject> getSubject() {
        return Optional.empty();
    }

    public Optional<DataLoaderRegistry> getDataLoaderRegistry() {
        return Optional.ofNullable(this.dataLoaderRegistry);
    }

    public BatchContext getBatchContext() {
        return this.batchContext;
    }

    public static class BatchContext {
        private final List<String> statements = new ArrayList<String>();
        private final CompletableFuture<ResultSet> executionFuture = new CompletableFuture();
        private AtomicReference<DataStore> dataStore = new AtomicReference();

        public CompletableFuture<ResultSet> getExecutionFuture() {
            return this.executionFuture;
        }

        public synchronized List<String> getStatements() {
            return this.statements;
        }

        public void setExecutionResult(CompletableFuture<ResultSet> result) {
            result.whenComplete((r, e) -> {
                if (e != null) {
                    this.executionFuture.completeExceptionally((Throwable)e);
                } else {
                    this.executionFuture.complete((ResultSet)r);
                }
            });
        }

        public void setExecutionResult(Exception ex) {
            this.executionFuture.completeExceptionally(ex);
        }

        public synchronized int add(String query) {
            this.statements.add(query);
            return this.statements.size();
        }

        public boolean setDataStore(DataStore dataStore) {
            return this.dataStore.getAndSet(dataStore) != null;
        }

        public Optional<DataStore> getDataStore() {
            return Optional.ofNullable(this.dataStore.get());
        }
    }
}

