/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.datastax.oss.driver.api.querybuilder.update.UpdateStart;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.MutationFetcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateMutationFetcher
extends MutationFetcher {
    public UpdateMutationFetcher(Table table, NameMapping nameMapping, Persistence persistence, AuthenticationService authenticationService) {
        super(table, nameMapping, persistence, authenticationService);
    }

    @Override
    protected String buildStatement(DataFetchingEnvironment environment, DataStore dataStore) {
        Map options;
        UpdateStart updateStart = QueryBuilder.update((String)this.table.keyspace(), (String)this.table.name());
        if (environment.containsArgument("options") && environment.getArgument("options") != null && (options = (Map)environment.getArgument("options")).containsKey("ttl") && options.get("ttl") != null) {
            updateStart = updateStart.usingTtl(((Integer)options.get("ttl")).intValue());
        }
        Update update = (Update)((Update)updateStart.set(this.buildAssignments(this.table, environment)).where(this.buildPkCKWhere(this.table, environment))).if_(this.buildIfConditions(this.table, (Map)environment.getArgument("ifCondition")));
        if (environment.containsArgument("ifExists") && environment.getArgument("ifExists") != null && ((Boolean)environment.getArgument("ifExists")).booleanValue()) {
            update = (Update)update.ifExists();
        }
        return update.asCql();
    }

    private List<Relation> buildPkCKWhere(Table table, DataFetchingEnvironment environment) {
        Map value = (Map)environment.getArgument("value");
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.getColumn(table, (String)entry.getKey());
            if (!table.partitionKeyColumns().contains(column) && !table.clusteringKeyColumns().contains(column)) continue;
            relations.add((Relation)Relation.column((String)column.name()).isEqualTo(this.toCqlTerm(column, entry.getValue())));
        }
        return relations;
    }

    private List<Assignment> buildAssignments(Table table, DataFetchingEnvironment environment) {
        Map value = (Map)environment.getArgument("value");
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.getColumn(table, (String)entry.getKey());
            if (table.partitionKeyColumns().contains(column) || table.clusteringKeyColumns().contains(column)) continue;
            assignments.add(Assignment.setColumn((String)column.name(), (Term)this.toCqlTerm(column, entry.getValue())));
        }
        return assignments;
    }
}

