/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.SelectedField;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.DataTypeMapping;
import io.stargate.graphql.schema.fetchers.dml.DmlFetcher;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class QueryFetcher
extends DmlFetcher {
    public QueryFetcher(Table table, NameMapping nameMapping, Persistence persistence, AuthenticationService authenticationService) {
        super(table, nameMapping, persistence, authenticationService);
    }

    @Override
    protected Map<String, Object> get(DataFetchingEnvironment environment, DataStore dataStore) throws Exception {
        String statement = this.buildQuery(environment);
        CompletableFuture rs = dataStore.query(statement, new Object[0]);
        ResultSet resultSet = (ResultSet)rs.get();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("values", resultSet.currentPageRows().stream().map(row -> DataTypeMapping.toGraphQLValue(this.nameMapping, this.table, row)).collect(Collectors.toList()));
        ByteBuffer pageState = resultSet.getPagingState();
        if (pageState != null) {
            result.put("pageState", Base64.getEncoder().encodeToString(pageState.array()));
        }
        return result;
    }

    private String buildQuery(DataFetchingEnvironment environment) {
        Map options;
        Object limit;
        Select select = ((Select)QueryBuilder.selectFrom((String)this.table.keyspace(), (String)this.table.name()).columns(this.buildQueryColumns(environment)).where(this.buildClause(this.table, environment))).orderBy(this.buildOrderBy(environment));
        if (environment.containsArgument("options") && (limit = (options = (Map)environment.getArgument("options")).get("limit")) != null) {
            select = select.limit(((Integer)limit).intValue());
        }
        return select.asCql();
    }

    private Map<String, ClusteringOrder> buildOrderBy(DataFetchingEnvironment environment) {
        if (environment.containsArgument("orderBy")) {
            LinkedHashMap<String, ClusteringOrder> orderMap = new LinkedHashMap<String, ClusteringOrder>();
            List orderList = (List)environment.getArgument("orderBy");
            for (String order : orderList) {
                int split = order.lastIndexOf("_");
                String column = order.substring(0, split);
                boolean desc = order.substring(split + 1).equals("DESC");
                orderMap.put(this.getDBColumnName(this.table, column), desc ? ClusteringOrder.DESC : ClusteringOrder.ASC);
            }
            return orderMap;
        }
        return ImmutableMap.of();
    }

    private List<String> buildQueryColumns(DataFetchingEnvironment environment) {
        if (environment.getSelectionSet().contains("values")) {
            SelectedField field = environment.getSelectionSet().getField("values");
            ArrayList<String> fields = new ArrayList<String>();
            for (SelectedField selectedField : field.getSelectionSet().getFields()) {
                String column;
                if ("__typename".equals(selectedField.getName()) || (column = this.getDBColumnName(this.table, selectedField.getName())) == null) continue;
                fields.add(column);
            }
            return fields;
        }
        return ImmutableList.of();
    }
}

