/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.ddl;

import com.google.common.collect.ImmutableMap;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.SelectedField;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class KeyspaceFormatter {
    KeyspaceFormatter() {
    }

    static List<Map<String, Object>> formatResult(Set<Keyspace> keyspaces, DataFetchingEnvironment environment) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Keyspace keyspace : keyspaces) {
            list.add(KeyspaceFormatter.formatResult(keyspace, environment));
        }
        return list;
    }

    static Map<String, Object> formatResult(Keyspace keyspace, DataFetchingEnvironment environment) {
        String tableName;
        Table table;
        SelectedField tableField;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"name", (Object)keyspace.name());
        if (environment.getSelectionSet().getField("tables") != null) {
            builder.put((Object)"tables", KeyspaceFormatter.buildTables(keyspace.tables()));
        }
        if ((tableField = environment.getSelectionSet().getField("table")) != null && (table = keyspace.table(tableName = (String)tableField.getArguments().get("name"))) != null) {
            builder.put((Object)"table", KeyspaceFormatter.buildTable(table));
        }
        builder.put((Object)"dcs", KeyspaceFormatter.buildDcs(keyspace));
        return builder.build();
    }

    private static List<Map<String, String>> buildDcs(Keyspace keyspace) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Map.Entry entries : keyspace.replication().entrySet()) {
            if (((String)entries.getKey()).equals("class") || ((String)entries.getKey()).equals("replication_factor")) continue;
            list.add((Map<String, String>)ImmutableMap.of((Object)"name", entries.getKey(), (Object)"replicas", entries.getValue()));
        }
        return list;
    }

    private static List<Map<String, Object>> buildTables(Set<Table> tables) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Table table : tables) {
            list.add(KeyspaceFormatter.buildTable(table));
        }
        return list;
    }

    private static Map<String, Object> buildTable(Table table) {
        return ImmutableMap.of((Object)"name", (Object)table.name(), (Object)"columns", KeyspaceFormatter.buildColumns(table.columns()));
    }

    private static List<Map<String, Object>> buildColumns(List<Column> columns) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Column column : columns) {
            list.add(KeyspaceFormatter.buildColumn(column));
        }
        return list;
    }

    private static Map<String, Object> buildColumn(Column column) {
        return ImmutableMap.of((Object)"kind", (Object)KeyspaceFormatter.buildColumnKind(column), (Object)"name", (Object)column.name(), (Object)"type", KeyspaceFormatter.buildDataType(column.type()));
    }

    private static Map<String, Object> buildDataType(Column.ColumnType columntype) {
        if (columntype.isParameterized()) {
            return ImmutableMap.of((Object)"basic", (Object)KeyspaceFormatter.buildBasicType(columntype), (Object)"info", KeyspaceFormatter.buildDataTypeInfo(columntype));
        }
        return ImmutableMap.of((Object)"basic", (Object)KeyspaceFormatter.buildBasicType(columntype));
    }

    private static Map<String, List<Map<String, Object>>> buildDataTypeInfo(Column.ColumnType columntype) {
        assert (columntype.isParameterized());
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Column.ColumnType type : columntype.parameters()) {
            list.add(KeyspaceFormatter.buildDataType(type));
        }
        return ImmutableMap.of((Object)"subTypes", list);
    }

    private static String buildBasicType(Column.ColumnType columntype) {
        return columntype.rawType().name().toUpperCase();
    }

    private static String buildColumnKind(Column column) {
        switch (column.kind()) {
            case PartitionKey: {
                return "PARTITION";
            }
            case Clustering: {
                return "CLUSTERING";
            }
            case Regular: {
                return "REGULAR";
            }
            case Static: {
                return "STATIC";
            }
        }
        return "UNKNOWN";
    }
}

