/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.ddl;

import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableDropColumnEnd;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableStart;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.graphql.schema.fetchers.ddl.DdlQueryFetcher;
import java.util.List;

public class AlterTableDropFetcher
extends DdlQueryFetcher {
    public AlterTableDropFetcher(Persistence persistence, AuthenticationService authenticationService) {
        super(persistence, authenticationService);
    }

    @Override
    public String getQuery(DataFetchingEnvironment dataFetchingEnvironment) {
        AlterTableStart start = SchemaBuilder.alterTable((String)((String)dataFetchingEnvironment.getArgument("keyspaceName")), (String)((String)dataFetchingEnvironment.getArgument("tableName")));
        List toDrop = (List)dataFetchingEnvironment.getArgument("toDrop");
        if (toDrop.isEmpty()) {
            throw new IllegalArgumentException("toDrop must contain at least one element");
        }
        AlterTableDropColumnEnd table = null;
        for (String column : toDrop) {
            if (table != null) {
                table = table.dropColumn(column);
                continue;
            }
            table = start.dropColumn(column);
        }
        return table.build().getQuery();
    }
}

