/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.CustomScalar;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.DeleteMutationFetcher;
import io.stargate.graphql.schema.fetchers.dml.InsertMutationFetcher;
import io.stargate.graphql.schema.fetchers.dml.QueryFetcher;
import io.stargate.graphql.schema.fetchers.dml.UpdateMutationFetcher;
import io.stargate.graphql.schema.types.GqlMapBuilder;
import io.stargate.graphql.util.CaseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DmlSchemaBuilder {
    private static final Logger log = LoggerFactory.getLogger(DmlSchemaBuilder.class);
    private final Persistence persistence;
    private final AuthenticationService authenticationService;
    private final Map<Column.ColumnType, GraphQLInputObjectType> filterInputTypes;
    private final Map<Table, GraphQLOutputType> entityResultMap = new HashMap<Table, GraphQLOutputType>();
    private final Map<String, GraphQLType> typeCache = new HashMap<String, GraphQLType>();
    private final NameMapping nameMapping;
    private final Keyspace keyspace;
    private GraphQLInputType mutationOptions = GraphQLInputObjectType.newInputObject().name("MutationOptions").field(GraphQLInputObjectField.newInputObjectField().name("consistency").type((GraphQLInputType)GraphQLEnumType.newEnum().name("MutationConsistency").value("LOCAL_ONE").value("LOCAL_QUORUM").value("ALL").build()).build()).field(GraphQLInputObjectField.newInputObjectField().name("serialConsistency").type((GraphQLInputType)GraphQLEnumType.newEnum().name("SerialConsistency").value("SERIAL").value("LOCAL_SERIAL").build()).build()).field(GraphQLInputObjectField.newInputObjectField().name("ttl").type((GraphQLInputType)Scalars.GraphQLInt).defaultValue((Object)-1).build()).build();

    DmlSchemaBuilder(Persistence persistence, AuthenticationService authenticationService, Keyspace keyspace) {
        this.persistence = persistence;
        this.authenticationService = authenticationService;
        this.keyspace = keyspace;
        this.nameMapping = new NameMapping(keyspace.tables(), keyspace.userDefinedTypes());
        this.filterInputTypes = this.buildFilterInputTypes();
    }

    GraphQLSchema build() {
        GraphQLSchema.Builder builder = new GraphQLSchema.Builder();
        for (UserDefinedType udt : this.keyspace.userDefinedTypes()) {
            builder.additionalTypes(this.buildTypesForUdt(udt));
        }
        ArrayList<GraphQLFieldDefinition> queryFields = new ArrayList<GraphQLFieldDefinition>();
        ArrayList<GraphQLFieldDefinition> mutationFields = new ArrayList<GraphQLFieldDefinition>();
        for (Table table : this.keyspace.tables()) {
            List<GraphQLFieldDefinition> tableMutationFields;
            List<GraphQLFieldDefinition> tableQueryField;
            Set<GraphQLType> additionalTypes;
            try {
                additionalTypes = this.buildTypesForTable(table);
                tableQueryField = this.buildQuery(table);
                tableMutationFields = this.buildMutations(table);
            }
            catch (Exception e) {
                log.warn("Skipping table " + table.name());
                continue;
            }
            builder.additionalTypes(additionalTypes);
            queryFields.addAll(tableQueryField);
            mutationFields.addAll(tableMutationFields);
        }
        if (queryFields.isEmpty()) {
            GraphQLFieldDefinition emptyQueryField = GraphQLFieldDefinition.newFieldDefinition().name("__keyspaceEmptyQuery").description("Placeholder query that is exposed when a keyspace is empty.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(d -> true).build();
            queryFields.add(emptyQueryField);
        }
        if (mutationFields.isEmpty()) {
            GraphQLFieldDefinition emptyMutationField = GraphQLFieldDefinition.newFieldDefinition().name("__keyspaceEmptyMutation").description("Placeholder mutation that is exposed when a keyspace is empty.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(d -> true).build();
            mutationFields.add(emptyMutationField);
        }
        builder.additionalType(this.buildQueryOptionsInputType());
        builder.query(this.buildQueries(queryFields));
        builder.mutation(this.buildMutationRoot(mutationFields));
        return builder.build();
    }

    private GraphQLObjectType buildMutationRoot(List<GraphQLFieldDefinition> mutationFields) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("Mutation");
        for (GraphQLFieldDefinition mutation : mutationFields) {
            builder.field(mutation);
        }
        return builder.build();
    }

    private GraphQLObjectType buildQueries(List<GraphQLFieldDefinition> queryFields) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("Query");
        for (GraphQLFieldDefinition fieldDefinition : queryFields) {
            builder.field(fieldDefinition);
        }
        return builder.build();
    }

    private List<GraphQLFieldDefinition> buildQuery(Table table) {
        GraphQLFieldDefinition query = GraphQLFieldDefinition.newFieldDefinition().name(CaseUtil.toLowerCamel(table.name())).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "Input"))).argument(GraphQLArgument.newArgument().name("filter").type((GraphQLInputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "FilterInput"))).argument(GraphQLArgument.newArgument().name("orderBy").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "Order")))).argument(GraphQLArgument.newArgument().name("options").type((GraphQLInputType)new GraphQLTypeReference("QueryOptions"))).type(this.buildEntityResultOutput(table)).dataFetcher((DataFetcher)new QueryFetcher(table, this.nameMapping, this.persistence, this.authenticationService)).build();
        GraphQLFieldDefinition filterQuery = GraphQLFieldDefinition.newFieldDefinition().name(CaseUtil.toLowerCamel(table.name()) + "Filter").deprecate("No longer supported. Use root type instead.").argument(GraphQLArgument.newArgument().name("filter").type((GraphQLInputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "FilterInput"))).argument(GraphQLArgument.newArgument().name("orderBy").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "Order")))).argument(GraphQLArgument.newArgument().name("options").type((GraphQLInputType)new GraphQLTypeReference("QueryOptions"))).type(this.buildEntityResultOutput(table)).dataFetcher((DataFetcher)new QueryFetcher(table, this.nameMapping, this.persistence, this.authenticationService)).build();
        return ImmutableList.of((Object)query, (Object)filterQuery);
    }

    private List<GraphQLFieldDefinition> buildMutations(Table table) {
        ArrayList<GraphQLFieldDefinition> mutationFields = new ArrayList<GraphQLFieldDefinition>();
        mutationFields.add(this.buildDelete(table));
        mutationFields.add(this.buildInsert(table));
        mutationFields.add(this.buildUpdate(table));
        return mutationFields;
    }

    private Set<GraphQLType> buildTypesForTable(Table table) {
        HashSet<GraphQLType> additionalTypes = new HashSet<GraphQLType>();
        additionalTypes.add((GraphQLType)this.buildType(table));
        additionalTypes.add(this.buildInputType(table));
        additionalTypes.add(this.buildOrderType(table));
        additionalTypes.add((GraphQLType)this.buildMutationResult(table));
        additionalTypes.add(this.buildFilterInput(table));
        return additionalTypes;
    }

    private GraphQLType buildFilterInput(Table table) {
        return GraphQLInputObjectType.newInputObject().name((String)this.nameMapping.getEntityNames().get((Object)table) + "FilterInput").fields(this.buildFilterInputFields(table)).build();
    }

    private GraphQLFieldDefinition buildUpdate(Table table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("update" + (String)this.nameMapping.getEntityNames().get((Object)table)).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "Input")))).argument(GraphQLArgument.newArgument().name("ifExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("ifCondition").type((GraphQLInputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "FilterInput"))).argument(GraphQLArgument.newArgument().name("options").type(this.mutationOptions)).type((GraphQLOutputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "MutationResult")).dataFetcher((DataFetcher)new UpdateMutationFetcher(table, this.nameMapping, this.persistence, this.authenticationService)).build();
    }

    private GraphQLFieldDefinition buildInsert(Table table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("insert" + (String)this.nameMapping.getEntityNames().get((Object)table)).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "Input")))).argument(GraphQLArgument.newArgument().name("ifNotExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("options").type(this.mutationOptions)).type((GraphQLOutputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "MutationResult")).dataFetcher((DataFetcher)new InsertMutationFetcher(table, this.nameMapping, this.persistence, this.authenticationService)).build();
    }

    private GraphQLFieldDefinition buildDelete(Table table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("delete" + (String)this.nameMapping.getEntityNames().get((Object)table)).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "Input")))).argument(GraphQLArgument.newArgument().name("ifExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("ifCondition").type((GraphQLInputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "FilterInput"))).argument(GraphQLArgument.newArgument().name("options").type(this.mutationOptions)).type((GraphQLOutputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table) + "MutationResult")).dataFetcher((DataFetcher)new DeleteMutationFetcher(table, this.nameMapping, this.persistence, this.authenticationService)).build();
    }

    private Map<Column.ColumnType, GraphQLInputObjectType> buildFilterInputTypes() {
        GraphQLInputObjectType stringFilterInput = DmlSchemaBuilder.filterInputType(Scalars.GraphQLString);
        GraphQLInputObjectType intFilterInput = DmlSchemaBuilder.filterInputType(Scalars.GraphQLInt);
        GraphQLInputObjectType floatFilterInput = DmlSchemaBuilder.filterInputType(Scalars.GraphQLFloat);
        GraphQLInputObjectType uuidFilterInput = DmlSchemaBuilder.filterInputType(CustomScalar.UUID.getGraphQLScalar());
        GraphQLInputObjectType timestampFilterInput = DmlSchemaBuilder.filterInputType(CustomScalar.TIMESTAMP.getGraphQLScalar());
        GraphQLInputObjectType timeUUIDFilterInput = DmlSchemaBuilder.filterInputType(CustomScalar.TIMEUUID.getGraphQLScalar());
        GraphQLInputObjectType inetFilterInput = DmlSchemaBuilder.filterInputType(CustomScalar.INET.getGraphQLScalar());
        GraphQLInputObjectType bigIntFilterInput = DmlSchemaBuilder.filterInputType(CustomScalar.BIGINT.getGraphQLScalar());
        GraphQLInputObjectType decimalFilterInput = DmlSchemaBuilder.filterInputType(CustomScalar.DECIMAL.getGraphQLScalar());
        GraphQLInputObjectType varintFilterInput = DmlSchemaBuilder.filterInputType(CustomScalar.VARINT.getGraphQLScalar());
        GraphQLInputObjectType blobFilterInput = DmlSchemaBuilder.filterInputType(CustomScalar.BLOB.getGraphQLScalar());
        return ImmutableMap.builder().put((Object)Column.Type.Int, (Object)intFilterInput).put((Object)Column.Type.Smallint, (Object)intFilterInput).put((Object)Column.Type.Tinyint, (Object)intFilterInput).put((Object)Column.Type.Text, (Object)stringFilterInput).put((Object)Column.Type.Varchar, (Object)stringFilterInput).put((Object)Column.Type.Float, (Object)floatFilterInput).put((Object)Column.Type.Double, (Object)floatFilterInput).put((Object)Column.Type.Uuid, (Object)uuidFilterInput).put((Object)Column.Type.Timestamp, (Object)timestampFilterInput).put((Object)Column.Type.Timeuuid, (Object)timeUUIDFilterInput).put((Object)Column.Type.Inet, (Object)inetFilterInput).put((Object)Column.Type.Bigint, (Object)bigIntFilterInput).put((Object)Column.Type.Decimal, (Object)decimalFilterInput).put((Object)Column.Type.Varint, (Object)varintFilterInput).put((Object)Column.Type.Blob, (Object)blobFilterInput).build();
    }

    private List<GraphQLInputObjectField> buildFilterInputFields(Table table) {
        ArrayList<GraphQLInputObjectField> fields = new ArrayList<GraphQLInputObjectField>();
        for (Column columnMetadata : table.columns()) {
            Column.ColumnType type = columnMetadata.type();
            if (type != null && type.isUserDefined()) {
                assert (type instanceof UserDefinedType);
                fields.add(GraphQLInputObjectField.newInputObjectField().name((String)this.nameMapping.getColumnNames(table).get((Object)columnMetadata)).type((GraphQLInputType)new GraphQLTypeReference((String)this.nameMapping.getUdtNames().get((Object)type.frozen(false)) + "FilterInput")).build());
                continue;
            }
            if (this.filterInputTypes.get(type) == null) continue;
            fields.add(GraphQLInputObjectField.newInputObjectField().name((String)this.nameMapping.getColumnNames(table).get((Object)columnMetadata)).type(this.getFilterInputTypeRef(type)).build());
        }
        Preconditions.checkState((!fields.isEmpty() ? 1 : 0) != 0, (Object)"Could not generate an input type for table, skipping.");
        return fields;
    }

    private GraphQLInputType getFilterInputTypeRef(Column.ColumnType dataType) {
        return (GraphQLInputType)this.filterInputTypes.get(dataType);
    }

    private static GraphQLInputObjectType filterInputType(GraphQLScalarType type) {
        return DmlSchemaBuilder.filterInputType(type.getName() + "FilterInput", (GraphQLInputType)type);
    }

    private static GraphQLInputObjectType filterInputType(String filterInputTypeName, GraphQLInputType elementType) {
        return GraphQLInputObjectType.newInputObject().name(filterInputTypeName).field(GraphQLInputObjectField.newInputObjectField().name("eq").type(elementType)).field(GraphQLInputObjectField.newInputObjectField().name("notEq").type(elementType)).field(GraphQLInputObjectField.newInputObjectField().name("gt").type(elementType)).field(GraphQLInputObjectField.newInputObjectField().name("gte").type(elementType)).field(GraphQLInputObjectField.newInputObjectField().name("lt").type(elementType)).field(GraphQLInputObjectField.newInputObjectField().name("lte").type(elementType)).field(GraphQLInputObjectField.newInputObjectField().name("in").type((GraphQLInputType)new GraphQLList((GraphQLType)elementType))).build();
    }

    private GraphQLOutputType buildMutationResult(Table table) {
        return GraphQLObjectType.newObject().name((String)this.nameMapping.getEntityNames().get((Object)table) + "MutationResult").field(GraphQLFieldDefinition.newFieldDefinition().name("applied").type((GraphQLOutputType)Scalars.GraphQLBoolean)).field(GraphQLFieldDefinition.newFieldDefinition().name("value").type((GraphQLOutputType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table)))).build();
    }

    private GraphQLType buildQueryOptionsInputType() {
        return GraphQLInputObjectType.newInputObject().name("QueryOptions").field(GraphQLInputObjectField.newInputObjectField().name("consistency").type((GraphQLInputType)GraphQLEnumType.newEnum().name("QueryConsistency").value("LOCAL_ONE").value("LOCAL_QUORUM").value("ALL").value("SERIAL").value("LOCAL_SERIAL").build()).build()).field(GraphQLInputObjectField.newInputObjectField().name("limit").type((GraphQLInputType)Scalars.GraphQLInt).build()).field(GraphQLInputObjectField.newInputObjectField().name("pageSize").type((GraphQLInputType)Scalars.GraphQLInt).defaultValue((Object)100).build()).field(GraphQLInputObjectField.newInputObjectField().name("pageState").type((GraphQLInputType)Scalars.GraphQLString).build()).build();
    }

    private GraphQLType buildOrderType(Table table) {
        GraphQLEnumType.Builder input = GraphQLEnumType.newEnum().name((String)this.nameMapping.getEntityNames().get((Object)table) + "Order");
        for (Column columnMetadata : table.columns()) {
            input.value((String)this.nameMapping.getColumnNames(table).get((Object)columnMetadata) + "_DESC");
            input.value((String)this.nameMapping.getColumnNames(table).get((Object)columnMetadata) + "_ASC");
        }
        return input.build();
    }

    private GraphQLType buildInputType(Table table) {
        GraphQLInputObjectType.Builder input = GraphQLInputObjectType.newInputObject().name((String)this.nameMapping.getEntityNames().get((Object)table) + "Input");
        for (Column columnMetadata : table.columns()) {
            try {
                GraphQLInputObjectField field = GraphQLInputObjectField.newInputObjectField().name((String)this.nameMapping.getColumnNames(table).get((Object)columnMetadata)).type((GraphQLInputType)this.getGraphQLType(columnMetadata.type(), true)).build();
                input.field(field);
            }
            catch (Exception e) {
                log.error(String.format("Input type for %s could not be created", columnMetadata.name()), (Throwable)e);
            }
        }
        return input.build();
    }

    private GraphQLOutputType buildEntityResultOutput(Table table) {
        if (this.entityResultMap.containsKey(table)) {
            return this.entityResultMap.get(table);
        }
        GraphQLObjectType entityResultType = GraphQLObjectType.newObject().name((String)this.nameMapping.getEntityNames().get((Object)table) + "Result").field(GraphQLFieldDefinition.newFieldDefinition().name("pageState").type((GraphQLOutputType)Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("values").type((GraphQLOutputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference((String)this.nameMapping.getEntityNames().get((Object)table)))))).build();
        this.entityResultMap.put(table, (GraphQLOutputType)entityResultType);
        return entityResultType;
    }

    public GraphQLObjectType buildType(Table table) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name((String)this.nameMapping.getEntityNames().get((Object)table));
        for (Column columnMetadata : table.columns()) {
            try {
                GraphQLFieldDefinition.Builder fieldBuilder = this.buildOutputField(table, columnMetadata);
                builder.field(fieldBuilder.build());
            }
            catch (Exception e) {
                log.error(String.format("Type for %s could not be created", columnMetadata.name()), (Throwable)e);
            }
        }
        return builder.build();
    }

    private GraphQLFieldDefinition.Builder buildOutputField(Table table, Column columnMetadata) {
        return new GraphQLFieldDefinition.Builder().name((String)this.nameMapping.getColumnNames(table).get((Object)columnMetadata)).type((GraphQLOutputType)this.getGraphQLType(columnMetadata.type(), false));
    }

    private Set<GraphQLType> buildTypesForUdt(UserDefinedType udt) {
        String typeNameBase = (String)this.nameMapping.getUdtNames().get((Object)udt.frozen(false));
        GraphQLObjectType.Builder outputType = GraphQLObjectType.newObject().name(typeNameBase);
        for (Object column : udt.columns()) {
            try {
                outputType.field(new GraphQLFieldDefinition.Builder().name((String)this.nameMapping.getFieldNames(udt).get(column)).type((GraphQLOutputType)this.getGraphQLType(column.type(), false)).build());
            }
            catch (Exception e) {
                log.error(String.format("Type for %s could not be created", column.name()), (Throwable)e);
            }
        }
        GraphQLInputObjectType.Builder inputType = GraphQLInputObjectType.newInputObject().name(typeNameBase + "Input");
        for (Column column : udt.columns()) {
            try {
                inputType.field(GraphQLInputObjectField.newInputObjectField().name((String)this.nameMapping.getFieldNames(udt).get((Object)column)).type((GraphQLInputType)this.getGraphQLType(column.type(), true)).build());
            }
            catch (Exception e) {
                log.error(String.format("Input type for %s could not be created", column.name()), (Throwable)e);
            }
        }
        GraphQLInputObjectType filterInputType = DmlSchemaBuilder.filterInputType(typeNameBase + "FilterInput", (GraphQLInputType)new GraphQLTypeReference(typeNameBase + "Input"));
        return ImmutableSet.of((Object)outputType.build(), (Object)inputType.build(), (Object)filterInputType);
    }

    private GraphQLType getGraphQLType(Column.ColumnType type, boolean isInput) {
        return DmlSchemaBuilder.getGraphQLType(type, isInput, this.typeCache, this.nameMapping);
    }

    @VisibleForTesting
    static GraphQLType getGraphQLType(Column.ColumnType type, boolean isInput, Map<String, GraphQLType> typeCache, NameMapping nameMapping) {
        switch (type.rawType()) {
            case Ascii: {
                return CustomScalar.ASCII.getGraphQLScalar();
            }
            case Bigint: {
                return CustomScalar.BIGINT.getGraphQLScalar();
            }
            case Blob: {
                return CustomScalar.BLOB.getGraphQLScalar();
            }
            case Boolean: {
                return Scalars.GraphQLBoolean;
            }
            case Counter: {
                return CustomScalar.COUNTER.getGraphQLScalar();
            }
            case Decimal: {
                return CustomScalar.DECIMAL.getGraphQLScalar();
            }
            case Double: {
                return Scalars.GraphQLFloat;
            }
            case Float: {
                return CustomScalar.FLOAT.getGraphQLScalar();
            }
            case Int: 
            case Smallint: 
            case Tinyint: {
                return Scalars.GraphQLInt;
            }
            case Text: 
            case Varchar: {
                return Scalars.GraphQLString;
            }
            case Timestamp: {
                return CustomScalar.TIMESTAMP.getGraphQLScalar();
            }
            case Uuid: {
                return CustomScalar.UUID.getGraphQLScalar();
            }
            case Varint: {
                return CustomScalar.VARINT.getGraphQLScalar();
            }
            case Timeuuid: {
                return CustomScalar.TIMEUUID.getGraphQLScalar();
            }
            case Inet: {
                return CustomScalar.INET.getGraphQLScalar();
            }
            case Date: {
                return CustomScalar.DATE.getGraphQLScalar();
            }
            case Time: {
                return CustomScalar.TIME.getGraphQLScalar();
            }
            case List: 
            case Set: {
                return new GraphQLList(DmlSchemaBuilder.getGraphQLType((Column.ColumnType)type.parameters().get(0), isInput, typeCache, nameMapping));
            }
            case Map: {
                GraphQLType keyType = DmlSchemaBuilder.getGraphQLType((Column.ColumnType)type.parameters().get(0), isInput, typeCache, nameMapping);
                GraphQLType valueType = DmlSchemaBuilder.getGraphQLType((Column.ColumnType)type.parameters().get(1), isInput, typeCache, nameMapping);
                return new GqlMapBuilder(keyType, valueType, isInput, typeCache).build();
            }
            case UDT: {
                UserDefinedType udt = (UserDefinedType)type.frozen(false);
                return new GraphQLTypeReference((String)nameMapping.getUdtNames().get((Object)udt) + (isInput ? "Input" : ""));
            }
        }
        throw new RuntimeException("Unsupported data type " + type.name());
    }
}

