/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.graphqlservlet;

import graphql.kickstart.execution.context.GraphQLContext;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.DefaultClaims;
import java.util.Optional;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import org.dataloader.DataLoaderRegistry;

public class HTTPAwareContextImpl
implements GraphQLContext {
    private final DataLoaderRegistry dataLoaderRegistry;
    private Session session;
    private HandshakeRequest handshakeRequest;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private static final String HEADER = "Authorization";
    private static final String PREFIX = "Bearer ";

    public HTTPAwareContextImpl(DataLoaderRegistry dataLoaderRegistry, HttpServletRequest request, HttpServletResponse response) {
        this.dataLoaderRegistry = dataLoaderRegistry;
        this.request = request;
        this.response = response;
    }

    public HTTPAwareContextImpl(DataLoaderRegistry dataLoaderRegistry, Session session, HandshakeRequest handshakeRequest) {
        this.dataLoaderRegistry = dataLoaderRegistry;
        this.session = session;
        this.handshakeRequest = handshakeRequest;
    }

    public String getAuthToken() {
        return this.request.getHeader("X-Cassandra-Token");
    }

    public String getUserOrRole() {
        if (this.hasJWTToken()) {
            String authHeader = this.request.getHeader(HEADER);
            String jwt = authHeader.substring(authHeader.indexOf(PREFIX) + PREFIX.length());
            Claims claims = HTTPAwareContextImpl.decodeJWT(jwt);
            if (claims != null) {
                return (String)claims.get("X-Cassandra-User", String.class);
            }
            return null;
        }
        return null;
    }

    public static Claims decodeJWT(String jwt) {
        try {
            DefaultClaims claims = (DefaultClaims)Jwts.parser().parse(jwt).getBody();
            return claims;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean hasJWTToken() {
        String header = this.request.getHeader(HEADER);
        return header != null && header.startsWith(PREFIX);
    }

    public Optional<Subject> getSubject() {
        return Optional.empty();
    }

    public Optional<DataLoaderRegistry> getDataLoaderRegistry() {
        return Optional.ofNullable(this.dataLoaderRegistry);
    }
}

