/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.servlet.InstrumentedFilter;
import graphql.kickstart.servlet.CustomGraphQLServlet;
import graphql.kickstart.servlet.SchemaGraphQLServlet;
import io.stargate.auth.AuthenticationService;
import io.stargate.core.metrics.api.Metrics;
import io.stargate.db.Persistence;
import io.stargate.graphql.GraphqlActivator;
import io.stargate.graphql.PlaygroundServlet;
import java.io.IOException;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.osgi.framework.FrameworkUtil;

public class WebImpl {
    private final Server server = new Server();

    public WebImpl(Persistence persistence, Metrics metrics, AuthenticationService authentication) throws IOException {
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost(System.getProperty("stargate.listen_address"));
        connector.setPort(8080);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        ServletHolder servletHolder = new ServletHolder((Servlet)new CustomGraphQLServlet(persistence, authentication));
        context.addServlet(servletHolder, "/graphql/*");
        ServletHolder schema = new ServletHolder((Servlet)new SchemaGraphQLServlet(persistence, authentication));
        context.addServlet(schema, "/graphql-schema");
        ServletHolder playground = new ServletHolder((Servlet)new PlaygroundServlet(FrameworkUtil.getBundle(GraphqlActivator.class)));
        context.addServlet(playground, "/playground");
        EnumSet<DispatcherType> allDispatcherTypes = EnumSet.allOf(DispatcherType.class);
        FilterHolder corsFilter = new FilterHolder();
        corsFilter.setInitParameter("allowedMethods", "POST,GET,OPTIONS,PUT,DELETE,PATCH");
        corsFilter.setInitParameter("allowedOrigins", "*");
        corsFilter.setInitParameter("Access-Control-Allow-Origin", "*");
        corsFilter.setInitParameter("allowedHeaders", "*");
        corsFilter.setInitParameter("allowCredentials", "true");
        corsFilter.setInitParameter("exposedHeaders", "Date");
        corsFilter.setFilter((Filter)new CrossOriginFilter());
        context.addFilter(corsFilter, "/*", allDispatcherTypes);
        context.addFilter(InstrumentedFilter.class, "/graphql/*", allDispatcherTypes).setInitParameter("name-prefix", "io.stargate.GraphQL");
        context.addFilter(InstrumentedFilter.class, "/graphql-schema/*", allDispatcherTypes).setInitParameter("name-prefix", "io.stargate.GraphQLSchema");
        MetricRegistry metricRegistry = metrics.getRegistry("graphql");
        context.setAttribute(InstrumentedFilter.REGISTRY_ATTRIBUTE, (Object)metricRegistry);
        this.server.setHandler((Handler)context);
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }
}

