/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;

public class PlaygroundServlet
extends HttpServlet {
    private final String playgroundFile;

    public PlaygroundServlet(Bundle bundle) throws IOException {
        URL entry = bundle.getEntry("/playground.html");
        this.playgroundFile = new BufferedReader(new InputStreamReader(entry.openConnection().getInputStream())).lines().collect(Collectors.joining("\n"));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(200);
        response.setContentType("text/html");
        response.setCharacterEncoding("utf-8");
        String token = request.getHeader("x-cassandra-token");
        String formattedPlaygroundFile = this.playgroundFile.replaceFirst("AUTHENTICATION_TOKEN", token == null ? "" : token);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(formattedPlaygroundFile.getBytes());
        try {
            int bytesRead;
            ServletOutputStream os = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = byteArrayInputStream.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }
}

